/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.decrypt.CMSMessageContext;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierData;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierResult;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributes;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.policies.SignatureLayer;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.utils.DistinguishedName;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bouncycastle.cms.SignerInformation;

class SignedDataVerifierInner
extends SignedDataVerifierAbstract {
    private static final Logger LOGGER = Logger.getLogger(SignedDataVerifierInner.class);

    public SignedDataVerifierInner(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver) {
        super(SignatureLayer.INNER, signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
    }

    @Override
    public CryptoResult<SignedDataVerifierData> verifySignedData(CMSMessageContext<?> cmsMsgContext, SignedDataVerifierData outerVerificationData) {
        SignedDataVerifierResult result = new SignedDataVerifierResult();
        SigningPolicy actualSigningPolicy = outerVerificationData.getSigningPolicy();
        SignerInformation signerInformation = cmsMsgContext.getSignerInformation();
        if (!cmsMsgContext.isStreamingMode()) {
            result.setContent(cmsMsgContext.getContentStream());
        }
        result.setSignerInformation(signerInformation);
        result.setSignature(signerInformation.getSignature());
        SigningPolicy innerSigningPolicy = this.verifyAlgorithmsUsed(result, signerInformation);
        result.setSigningPolicy(innerSigningPolicy);
        actualSigningPolicy = this.defineSigningPolicy(result, innerSigningPolicy, actualSigningPolicy);
        SignerInfoAttributes signerInfoAttributes = this.getSignerInfoAttributes(result, signerInformation);
        X509Certificate signerCertificate = cmsMsgContext.getAuthenticationCertificate();
        result.setSignatureCert(signerCertificate);
        if (signerCertificate == null) {
            if (outerVerificationData.getAuthenticationCert() != null) {
                LOGGER.debug((Object)this.buildMsg("Verify inner signature with outer certificate: " + outerVerificationData.getAuthenticationCert().getSubjectX500Principal()));
                this.verifySignature(result, signerInformation, outerVerificationData.getAuthenticationCert());
                this.verifyCertificateKeyUsage(result, outerVerificationData.getAuthenticationCert());
            }
            return result;
        }
        if (outerVerificationData.getAuthenticationCert() != null) {
            this.verifyMessageIntegrity(result, outerVerificationData.getAuthenticationCert(), signerCertificate);
        }
        this.verifyCertificate(result, cmsMsgContext, signerInfoAttributes, outerVerificationData.getSigningTime(), actualSigningPolicy);
        return result;
    }

    private SigningPolicy defineSigningPolicy(SignedDataVerifierResult result, SigningPolicy innerSigningPolicy, SigningPolicy outerSigningPolicy) {
        if (outerSigningPolicy == null) {
            return innerSigningPolicy;
        }
        if (innerSigningPolicy == null) {
            return outerSigningPolicy;
        }
        if (!outerSigningPolicy.equals((Object)innerSigningPolicy)) {
            LOGGER.error((Object)this.buildMsg("Different policies found for inner and outer signature: " + (Object)((Object)outerSigningPolicy) + " - " + (Object)((Object)innerSigningPolicy)));
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
        return outerSigningPolicy;
    }

    private void verifyMessageIntegrity(SignedDataVerifierResult result, X509Certificate outer, X509Certificate inner) {
        if (!this.checkCertificateCorrelation(outer, inner)) {
            result.getErrors().add(NotificationError.MESSAGE_INTEGRITY_INVALID);
        }
    }

    private boolean checkCertificateCorrelation(X509Certificate outer, X509Certificate inner) {
        LOGGER.debug((Object)"Verify correlation between inner and outer certificate.");
        DistinguishedName outerDN = DistinguishedName.from(outer.getSubjectX500Principal());
        DistinguishedName innerDN = DistinguishedName.from(inner.getSubjectX500Principal());
        if (!outerDN.hasSerialNumber() && !innerDN.hasSerialNumber()) {
            LOGGER.warn((Object)"Certificates have no serialnumber. Subject must be same.");
            return outer.getSubjectX500Principal().equals(inner.getSubjectX500Principal());
        }
        if (outerDN.hasSerialNumber() && outerDN.getSerialNumber().equals(innerDN.getSerialNumber())) {
            LOGGER.info((Object)("Both certificates are owned by the same entity: " + outerDN.getSerialNumber()));
            return true;
        }
        LOGGER.warn((Object)String.format("SerialNumbers certificates do not match: " + outerDN.getSerialNumber() + " - " + innerDN.getSerialNumber(), new Object[0]));
        return false;
    }
}

