/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.utils.SOAPFaultFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapActionHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SoapActionHandler.class);

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        try {
            boolean hasSoapAction = false;
            if (context.containsKey((Object)"javax.xml.ws.soap.http.soapaction.use")) {
                hasSoapAction = (Boolean)context.get((Object)"javax.xml.ws.soap.http.soapaction.use");
            }
            if (hasSoapAction) {
                String soapAction = (String)context.get((Object)"javax.xml.ws.soap.http.soapaction.uri");
                LOG.debug("Adding SOAPAction to mimeheader");
                SOAPMessage msg = context.getMessage();
                String[] headers = msg.getMimeHeaders().getHeader("SOAPAction");
                if (headers != null) {
                    LOG.warn("Removing SOAPAction with values: " + ArrayUtils.toString((Object)headers));
                    msg.getMimeHeaders().removeHeader("SOAPAction");
                }
                msg.getMimeHeaders().addHeader("SOAPAction", soapAction);
                msg.saveChanges();
            }
            return true;
        }
        catch (SOAPException e) {
            throw SOAPFaultFactory.newSOAPFaultException("WSSecurity problem: [SOAPACTION]" + e.getMessage(), e);
        }
    }
}

