/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.utils;


import java.util.Properties;

import org.apache.log4j.Appender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.config.impl.ConfigurationModuleLoggingLog4j;
import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;


/**
 * Utility method to work with Logging
 * 
 * @author EHP
 * 
 */
public class LoggingUtils {

    private static final Logger LOG = LoggerFactory.getLogger(LoggingUtils.class);

    /**
     * Method to obtain a {@link TestAppender} that can be used to assert logging.
     * 
     * @return
     */
    public static TestAppender getTestAppender() {
        TestAppender appender = new TestAppender();
        registerAppender(appender);
        return appender;
    }

    /**
     * Method to bootstrap the default logging as soon as possible
     */
    public static void bootstrap() {
        try {
            new ConfigurationModuleLoggingLog4j().init(new Properties());
        } catch (Throwable e) {
            LOG.error("Unable to bootstrap log4j", e);
        }
    }

    /**
     * Method to register an {@link Appender}
     * 
     * @param appender
     */
    public static void registerAppender(Appender appender) {
        org.apache.log4j.Logger.getRootLogger().addAppender(appender);
    }


}