/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.encrypt;

import be.fgov.ehealth.etee.crypto.encrypt.CmsSigner;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;

class MessageSigner {
    private static final Logger LOGGER = Logger.getLogger(MessageSigner.class);
    private final CmsSigner innerMessageSigner;
    private final CmsSigner outerMessageSigner;

    MessageSigner(CmsSigner innerMessageSigner, CmsSigner outerMessageSigner) {
        this.innerMessageSigner = innerMessageSigner;
        this.outerMessageSigner = Preconditions.checkNotNull(outerMessageSigner);
    }

    MessageSigner(CmsSigner cmsSigner) {
        this(null, cmsSigner);
    }

    byte[] signInnerData(byte[] data) throws OperatorCreationException, OCSPException, CertificateException, NoSuchAlgorithmException, CMSException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Creating 'inner' signed data'");
        }
        return this.innerMessageSigner().signData(data, this.includeCertificateInSignature());
    }

    byte[] signOuterData(byte[] data) throws OperatorCreationException, OCSPException, CertificateException, NoSuchAlgorithmException, CMSException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Creating 'outer' signed data'");
        }
        return this.outerMessageSigner().signData(data, true);
    }

    OutputStream openInnerDataStream(OutputStream data) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Open stream for the 'inner' signed data'");
        }
        return this.innerMessageSigner().openDataToBeSignedStream(data, this.includeCertificateInSignature());
    }

    OutputStream openOuterDataStream(OutputStream data) throws OperatorCreationException, OCSPException, CertificateException, CMSException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Open stream for the 'outer' signed data'");
        }
        return this.outerMessageSigner().openDataToBeSignedStream(data, true);
    }

    private CmsSigner innerMessageSigner() {
        return this.innerMessageSigner == null ? this.outerMessageSigner : this.innerMessageSigner;
    }

    private CmsSigner outerMessageSigner() {
        return this.outerMessageSigner;
    }

    private boolean includeCertificateInSignature() {
        return this.innerMessageSigner != null;
    }
}

