/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * mock for configuration : just holds values in memory.
 * 
 * @author EHP
 */
public class InMemoryConfigurationMock implements Configuration {

    private Properties props = new Properties();


    @Override
    public String getProperty(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    @Override
    public Long getLongProperty(String key, Long defaultValue) {
        if (props.containsKey(key)) {
            return Long.valueOf(props.getProperty(key));
        } else {
            return defaultValue;
        }
    }

    @Override
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        if (props.containsKey(key)) {
            return Integer.valueOf(props.getProperty(key));
        } else {
            return defaultValue;
        }
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        if (props.containsKey(key)) {
            return Boolean.valueOf(props.getProperty(key));
        } else {
            return defaultValue;
        }
    }

    @Override
    public String getProperty(String key) {
        return props.getProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return props.containsKey(key);
    }

    @Override
    public URL getURLProperty(String property) {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public void setProperty(String key, String value) {
        props.setProperty(key, value);

    }

    @Override
    public boolean hasProperty(String key) {
        return props.contains(key);
    }


    @Override
    public boolean hasMatchingProperty(String rootKey) {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public List<String> getMatchingProperties(String rootKey) {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public void setConfigLocation(String location) throws TechnicalConnectorException {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public Duration getDurationProperty(String key, Long defaultValue, TimeUnit defaultTimeUnit) {
        throw new UnsupportedOperationException("not supported in mock");
    }

    @Override
    public boolean hasDurationProperty(String key) {
        return false;
    }

    @Override
    public void invalidate() {
        //
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        //

    }

}
