/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import java.security.Security;
import java.util.HashMap;
import java.util.Map;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.CadesOption;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;


/**
 * tests the SignatureBuilder.
 * 
 * @author EHP
 */
public class CadesBesSignatureTest extends AbstractSignatureTest {


    @BeforeClass
    public static void initBuilder() throws Exception {
        builder = SignatureBuilderFactory.getSignatureBuilder(AdvancedElectronicSignatureEnumeration.CAdES);
    }


    @Test
    public void testBuildCadesBes() throws Exception {
        byte[] signatureBytes = generateCadesBes();
        Assert.assertNotNull(signatureBytes);
        Assert.assertTrue(signatureBytes.length > 0);
    }

    private byte[] generateCadesBes() throws TechnicalConnectorException {
        Security.addProvider(new BouncyCastleProvider());
        Map<String, Object> options = new HashMap<String, Object>();
        options.put(CadesOption.SIGNATUREALGORITHM, "Sha1WithRSA");
        options.put(CadesOption.ENCAPSULATE, Boolean.TRUE);
        return builder.sign(credential, textToSign, options);
    }

    @Test
    public void testValidateGeneratedCadesBes() throws Exception {
        verifyCades(generateCadesBes(), textToSign);
    }

    @Test
    public void alteredCadesBes() throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        Map<String, Object> options = new HashMap<String, Object>();
        options.put(CadesOption.SIGNATUREALGORITHM, "Sha1WithRSA");
        options.put(CadesOption.ENCAPSULATE, Boolean.TRUE);
        byte[] signature = builder.sign(credential, textToSign, options);
        verifyCades(signature, textToSign_bis, SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
    }

}
