/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.etee;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.KeyStoreManager;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoFactory.class);
    public static final String PROPS_CRYPTO_CLASS = "crypto.classname";
    private static final String DEFAULT_CERT_CHECKER_CLASS = "be.ehealth.technicalconnector.service.etee.impl.CryptoImpl";
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PWD = "timestamp.signature.keystore.pwd";
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PATH = "timestamp.signature.keystore.path";
    public static final String SIGNING_TIME_EXPIRATION = "be.fgov.ehealth.etee.crypto.policies.SigningOption.SIGNING_TIME_EXPIRATION";
    public static final String SIGNING_CLOCK_SKEW = "be.fgov.ehealth.etee.crypto.policies.SigningOption.CLOCK_SKEW";
    public static final String SIGNING_TIME_TRUST_IMPLICIT = "be.fgov.ehealth.etee.crypto.policies.SigningOption.SIGNING_TIME_TRUST_IMPLICIT";
    public static final String SIGNING_TSA_CERT_STORE = "be.fgov.ehealth.etee.crypto.policies.SigningOption.TSA_CERT_STORE";
    public static final String OCSP_URI = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.OCSP_URI";
    public static final String OCSP_INJECT_RESPONSE = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.INJECT_RESPONSE";
    public static final String OCSP_CLOCK_SKEW = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CLOCK_SKEW";
    public static final String OCSP_CONNECTION_TIMEOUT = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CONNECTION_TIMEOUT";
    public static final String OCSP_CERT_STORE = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CERT_STORE";
    public static final String OCSP_READ_TIMEOUT = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.READ_TIMEOUT";
    public static final String OCSP_CONNECTION_USER_INTERACTION = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CONNECTION_USER_INTERACTION";
    private static final String PROP_CAKEYSTORE_PATH = "CAKEYSTORE_LOCATION";
    private static final String PROP_CAKEYSTORE_PASSWORD = "CAKEYSTORE_PASSWORD";
    private static final String PROP_KEYSTORE_DIR = "KEYSTORE_DIR";
    private static Configuration configuration = ConfigFactory.getConfigValidator();
    private static Map<OCSPOption, Object> ocspOptionMap;
    private static final Object mutex;
    private static ConfigurableFactoryHelper<Crypto> helper;

    private CryptoFactory() {
    }

    public static Crypto getCrypto(Credential encryption, Map<String, PrivateKey> decryptionKeys, String oCSPPolicy) throws TechnicalConnectorException {
        HashMap<String, Object> configParameters = new HashMap<String, Object>();
        configParameters.put("datasealer.credential", encryption);
        configParameters.put("dataunsealer.pkmap", decryptionKeys);
        configParameters.put("cryptolib.ocsp.policy", OCSPPolicy.valueOf((String)oCSPPolicy));
        HashMap<SigningOption, Object> signingOptions = new HashMap<SigningOption, Object>();
        signingOptions.put(SigningOption.SIGNING_TIME_EXPIRATION, configuration.getIntegerProperty(SIGNING_TIME_EXPIRATION, 5));
        signingOptions.put(SigningOption.CLOCK_SKEW, configuration.getLongProperty(SIGNING_CLOCK_SKEW, 300000L));
        signingOptions.put(SigningOption.SIGNING_TIME_TRUST_IMPLICIT, configuration.getBooleanProperty(SIGNING_TIME_TRUST_IMPLICIT, Boolean.FALSE));
        signingOptions.put(SigningOption.TSA_TRUST_STORE, CryptoFactory.getKeyStore(TIMESTAMP_SIGNATURE_KEYSTORE_PATH, TIMESTAMP_SIGNATURE_KEYSTORE_PWD));
        signingOptions.put(SigningOption.TSA_CERT_STORE, CryptoFactory.generateCertStore(SIGNING_TSA_CERT_STORE, new KeyStore[0]));
        configParameters.put("cryptolib.signing.optionmap", signingOptions);
        configParameters.put("cryptolib.ocsp.optionmap", CryptoFactory.getOCSPOptions());
        return helper.getImplementation(configParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<OCSPOption, Object> getOCSPOptions() throws TechnicalConnectorException {
        if (ocspOptionMap == null) {
            Object object = mutex;
            synchronized (object) {
                ocspOptionMap = new HashMap<OCSPOption, Object>();
                ocspOptionMap.put(OCSPOption.OCSP_URI, configuration.getProperty(OCSP_URI));
                KeyStore trustStore = CryptoFactory.getCaCertificateStore();
                ocspOptionMap.put(OCSPOption.TRUST_STORE, trustStore);
                ocspOptionMap.put(OCSPOption.CERT_STORE, CryptoFactory.generateCertStore(OCSP_CERT_STORE, trustStore));
                ocspOptionMap.put(OCSPOption.INJECT_RESPONSE, configuration.getBooleanProperty(OCSP_INJECT_RESPONSE, Boolean.FALSE));
                ocspOptionMap.put(OCSPOption.CLOCK_SKEW, configuration.getLongProperty(OCSP_CLOCK_SKEW, 300000L));
                ocspOptionMap.put(OCSPOption.CONNECTION_TIMEOUT, configuration.getIntegerProperty(OCSP_CONNECTION_TIMEOUT, 3000));
                ocspOptionMap.put(OCSPOption.READ_TIMEOUT, configuration.getIntegerProperty(OCSP_READ_TIMEOUT, 3000));
                ocspOptionMap.put(OCSPOption.CONNECTION_USER_INTERACTION, configuration.getBooleanProperty(OCSP_CONNECTION_USER_INTERACTION, Boolean.FALSE));
            }
        }
        return ocspOptionMap;
    }

    public static void resetOCSPOptions() {
        ocspOptionMap = null;
    }

    public static KeyStore getCaCertificateStore() {
        return CryptoFactory.getKeyStore(PROP_CAKEYSTORE_PATH, PROP_CAKEYSTORE_PASSWORD);
    }

    private static KeyStore getKeyStore(String key, String password) {
        try {
            KeyStore keystore = null;
            char[] pwd = configuration.getProperty(password, "").toCharArray();
            String path = configuration.getProperty(key, "");
            if (StringUtils.isNotBlank((String)path)) {
                String keystorePath = configuration.getProperty(PROP_KEYSTORE_DIR, "") + path;
                try {
                    KeyStoreManager ocspKeyStoreManager = new KeyStoreManager(keystorePath, pwd);
                    keystore = ocspKeyStoreManager.getKeyStore();
                }
                catch (TechnicalConnectorException e) {
                    LOG.info("Unable to load keystore.", (Throwable)e);
                }
            }
            if (keystore == null) {
                keystore = KeyStore.getInstance("JKS");
                keystore.load(null, password.toCharArray());
            }
            return keystore;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public static Crypto getCrypto(Credential encryption, Map<String, PrivateKey> decryptionKeys) throws TechnicalConnectorException {
        return CryptoFactory.getCrypto(encryption, decryptionKeys, "NONE");
    }

    public static Crypto getCryptoFromSession() throws TechnicalConnectorException {
        SessionItem session = Session.getInstance().getSession();
        return CryptoFactory.getCrypto(session.getEncryptionCredential(), session.getEncryptionPrivateKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertStore generateCertStore(String baseKey, KeyStore ... stores) {
        try {
            InputStream stream;
            ArrayList<Object> certsAndCrls = new ArrayList<Object>();
            for (KeyStore store : stores) {
                try {
                    Enumeration<String> enumeration = store.aliases();
                    while (enumeration.hasMoreElements()) {
                        certsAndCrls.add(store.getCertificate(enumeration.nextElement()));
                    }
                    LOG.info("Added truststore in CertStore.");
                }
                catch (KeyStoreException e) {
                    LOG.warn("Unable to add truststore to CertStore", (Throwable)e);
                }
            }
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            for (String certLocation : configuration.getMatchingProperties(baseKey + ".CERT")) {
                stream = null;
                try {
                    stream = ConnectorIOUtils.getResourceAsStream(certLocation);
                    certsAndCrls.add(factory.generateCertificate(stream));
                    LOG.info("Added " + certLocation + " as CERT in CertStore.");
                }
                catch (Exception e) {
                    LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
                }
                finally {
                    ConnectorIOUtils.closeQuietly((Object)stream);
                }
            }
            for (String crlLocation : configuration.getMatchingProperties(baseKey + ".CRL")) {
                stream = null;
                try {
                    stream = ConnectorIOUtils.getResourceAsStream(crlLocation);
                    certsAndCrls.add(factory.generateCRL(stream));
                    LOG.info("Added " + crlLocation + " as CRL in CertStore.");
                }
                catch (Exception e) {
                    LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
                }
                finally {
                    ConnectorIOUtils.closeQuietly((Object)stream);
                }
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certsAndCrls));
        }
        catch (CertificateException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    static {
        mutex = new Object();
        helper = new ConfigurableFactoryHelper(PROPS_CRYPTO_CLASS, DEFAULT_CERT_CHECKER_CLASS);
    }
}

