/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.BeIDCards;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.client.impl.VoidLogger;
import be.fedict.commons.eid.client.spi.BeIDCardUI;
import be.fedict.commons.eid.client.spi.BeIDCardsUI;
import be.fedict.commons.eid.client.spi.Logger;
import be.fedict.commons.eid.dialogs.DefaultBeIDCardUI;
import be.fedict.commons.eid.dialogs.DefaultBeIDCardsUI;
import be.fedict.commons.eid.dialogs.Messages;
import be.fedict.commons.eid.jca.BeIDKeyStoreParameter;
import be.fedict.commons.eid.jca.BeIDPrivateKey;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.smartcardio.CardTerminal;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeIDKeyStore
extends KeyStoreSpi {
    private static final Log LOG = LogFactory.getLog(BeIDKeyStore.class);
    private BeIDKeyStoreParameter keyStoreParameter;
    private BeIDCard beIDCard;
    private List<X509Certificate> authnCertificateChain;
    private List<X509Certificate> signCertificateChain;
    private List<X509Certificate> rrnCertificateChain;
    private X509Certificate citizenCaCertificate;
    private X509Certificate rootCaCertificate;
    private X509Certificate authnCertificate;
    private X509Certificate signCertificate;
    private X509Certificate rrnCertificate;
    private CardTerminal cardTerminal;

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        String applicationName;
        boolean autoRecovery;
        boolean logoff;
        LOG.debug((Object)("engineGetKey: " + alias));
        BeIDCard beIDCard = this.getBeIDCard();
        if (null == this.keyStoreParameter) {
            logoff = false;
            autoRecovery = false;
            applicationName = null;
        } else {
            logoff = this.keyStoreParameter.getLogoff();
            autoRecovery = this.keyStoreParameter.getAutoRecovery();
            applicationName = this.keyStoreParameter.getApplicationName();
        }
        if ("Authentication".equals(alias)) {
            BeIDPrivateKey beIDPrivateKey = new BeIDPrivateKey(FileType.AuthentificationCertificate, beIDCard, logoff, autoRecovery, this, applicationName);
            return beIDPrivateKey;
        }
        if ("Signature".equals(alias)) {
            BeIDPrivateKey beIDPrivateKey = new BeIDPrivateKey(FileType.NonRepudiationCertificate, beIDCard, logoff, autoRecovery, this, applicationName);
            return beIDPrivateKey;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOG.debug((Object)("engineGetCertificateChain: " + alias));
        BeIDCard beIDCard = this.getBeIDCard();
        if ("Signature".equals(alias)) {
            try {
                if (null == this.signCertificateChain) {
                    this.signCertificateChain = beIDCard.getSigningCertificateChain();
                    this.signCertificate = this.signCertificateChain.get(0);
                    this.citizenCaCertificate = this.signCertificateChain.get(1);
                    this.rootCaCertificate = this.signCertificateChain.get(2);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("error: " + ex.getMessage()), (Throwable)ex);
                return null;
            }
            return this.signCertificateChain.toArray(new X509Certificate[0]);
        }
        if ("Authentication".equals(alias)) {
            try {
                if (null == this.authnCertificateChain) {
                    this.authnCertificateChain = beIDCard.getAuthenticationCertificateChain();
                    this.authnCertificate = this.authnCertificateChain.get(0);
                    this.citizenCaCertificate = this.authnCertificateChain.get(1);
                    this.rootCaCertificate = this.authnCertificateChain.get(2);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("error: " + ex.getMessage()), (Throwable)ex);
                return null;
            }
            return this.authnCertificateChain.toArray(new X509Certificate[0]);
        }
        if ("RRN".equals(alias)) {
            if (null == this.rrnCertificateChain) {
                try {
                    this.rrnCertificateChain = beIDCard.getRRNCertificateChain();
                }
                catch (Exception e) {
                    LOG.error((Object)("error: " + e.getMessage()), (Throwable)e);
                    return null;
                }
                this.rrnCertificate = this.rrnCertificateChain.get(0);
                this.rootCaCertificate = this.rrnCertificateChain.get(1);
            }
            return this.rrnCertificateChain.toArray(new X509Certificate[0]);
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        LOG.debug((Object)("engineGetCertificate: " + alias));
        BeIDCard beIDCard = this.getBeIDCard();
        if ("Signature".equals(alias)) {
            try {
                if (null == this.signCertificate) {
                    this.signCertificate = beIDCard.getSigningCertificate();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("error: " + ex.getMessage()), (Throwable)ex);
                return null;
            }
            return this.signCertificate;
        }
        if ("Authentication".equals(alias)) {
            try {
                if (null == this.authnCertificate) {
                    this.authnCertificate = beIDCard.getAuthenticationCertificate();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("error: " + ex.getMessage()), (Throwable)ex);
                return null;
            }
            return this.authnCertificate;
        }
        if ("CA".equals(alias)) {
            try {
                if (null == this.citizenCaCertificate) {
                    this.citizenCaCertificate = beIDCard.getCACertificate();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("error: " + e.getMessage()), (Throwable)e);
                return null;
            }
            return this.citizenCaCertificate;
        }
        if ("Root".equals(alias)) {
            try {
                if (null == this.rootCaCertificate) {
                    this.rootCaCertificate = beIDCard.getRootCACertificate();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("error: " + e.getMessage()), (Throwable)e);
                return null;
            }
            return this.rootCaCertificate;
        }
        if ("RRN".equals(alias)) {
            try {
                if (null == this.rrnCertificate) {
                    this.rrnCertificate = beIDCard.getRRNCertificate();
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("error: " + e.getMessage()), (Throwable)e);
                return null;
            }
            return this.rrnCertificate;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        X509Certificate certificate = (X509Certificate)this.engineGetCertificate(alias);
        if (null == certificate) {
            return null;
        }
        return certificate.getNotBefore();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException();
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException();
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new KeyStoreException();
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOG.debug((Object)"engineAliases");
        Vector<String> aliases = new Vector<String>();
        aliases.add("Authentication");
        aliases.add("Signature");
        aliases.add("CA");
        aliases.add("Root");
        aliases.add("RRN");
        return aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOG.debug((Object)("engineContainsAlias: " + alias));
        if ("Authentication".equals(alias)) {
            return true;
        }
        if ("Signature".equals(alias)) {
            return true;
        }
        if ("Root".equals(alias)) {
            return true;
        }
        if ("CA".equals(alias)) {
            return true;
        }
        return "RRN".equals(alias);
    }

    @Override
    public int engineSize() {
        return 2;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOG.debug((Object)("engineIsKeyEntry: " + alias));
        if ("Authentication".equals(alias)) {
            return true;
        }
        return "Signature".equals(alias);
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOG.debug((Object)("engineIsCertificateEntry: " + alias));
        if ("Root".equals(alias)) {
            return true;
        }
        if ("CA".equals(alias)) {
            return true;
        }
        return "RRN".equals(alias);
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug((Object)"engineStore");
        super.engineStore(param);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        LOG.debug((Object)("engineGetEntry: " + alias));
        if ("Authentication".equals(alias) || "Signature".equals(alias)) {
            PrivateKey privateKey = (PrivateKey)this.engineGetKey(alias, null);
            Certificate[] chain = this.engineGetCertificateChain(alias);
            KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chain);
            return privateKeyEntry;
        }
        if ("CA".equals(alias) || "Root".equals(alias) || "RRN".equals(alias)) {
            Certificate certificate = this.engineGetCertificate(alias);
            KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(certificate);
            return trustedCertificateEntry;
        }
        return super.engineGetEntry(alias, protParam);
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        LOG.debug((Object)("engineSetEntry: " + alias));
        super.engineSetEntry(alias, entry, protParam);
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        LOG.debug((Object)("engineEntryInstanceOf: " + alias));
        return super.engineEntryInstanceOf(alias, entryClass);
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug((Object)"engineLoad");
        this.beIDCard = null;
        this.authnCertificateChain = null;
        this.signCertificateChain = null;
        this.rrnCertificateChain = null;
        this.authnCertificate = null;
        this.signCertificate = null;
        this.citizenCaCertificate = null;
        this.rootCaCertificate = null;
        this.rrnCertificate = null;
        if (null == param) {
            return;
        }
        if (param instanceof BeIDKeyStoreParameter) {
            this.keyStoreParameter = (BeIDKeyStoreParameter)param;
            return;
        }
        if (param instanceof JFrame) {
            this.keyStoreParameter = new BeIDKeyStoreParameter();
            JFrame frame = (JFrame)((Object)param);
            this.keyStoreParameter.setParentComponent(frame);
            return;
        }
        throw new NoSuchAlgorithmException();
    }

    private BeIDCard getBeIDCard() {
        return this.getBeIDCard(false);
    }

    public BeIDCard getBeIDCard(boolean recover) {
        Logger logger;
        Locale locale;
        Component parentComponent;
        boolean cardReaderStickiness = null != this.keyStoreParameter ? this.keyStoreParameter.getCardReaderStickiness() : false;
        if (recover) {
            LOG.debug((Object)"recovering from error");
            this.beIDCard = null;
        }
        if (null != this.beIDCard) {
            return this.beIDCard;
        }
        if (null != this.keyStoreParameter) {
            this.beIDCard = this.keyStoreParameter.getBeIDCard();
        }
        if (null != this.beIDCard) {
            return this.beIDCard;
        }
        if (null != this.keyStoreParameter) {
            parentComponent = this.keyStoreParameter.getParentComponent();
            locale = this.keyStoreParameter.getLocale();
            logger = this.keyStoreParameter.getLogger();
        } else {
            parentComponent = null;
            locale = null;
            logger = null;
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null == logger) {
            logger = new VoidLogger();
        }
        Messages messages = Messages.getInstance((Locale)locale);
        DefaultBeIDCardsUI ui = new DefaultBeIDCardsUI(parentComponent, messages);
        BeIDCards beIDCards = new BeIDCards(logger, (BeIDCardsUI)ui);
        beIDCards.setLocale(locale);
        try {
            CardTerminal stickyCardTerminal = cardReaderStickiness ? this.cardTerminal : null;
            this.beIDCard = beIDCards.getOneBeIDCard(stickyCardTerminal);
            if (cardReaderStickiness) {
                this.cardTerminal = this.beIDCard.getCardTerminal();
                LOG.debug((Object)("sticky card reader: " + this.cardTerminal.getName()));
            }
            DefaultBeIDCardUI userInterface = new DefaultBeIDCardUI(parentComponent, messages);
            this.beIDCard.setUI((BeIDCardUI)userInterface);
        }
        catch (CancelledException cex) {
            throw new SecurityException("user cancelled");
        }
        if (null == this.beIDCard) {
            throw new SecurityException("missing eID card");
        }
        return this.beIDCard;
    }
}

