/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SigningCredential {
    private final PrivateKey privateKey;
    private final List<X509Certificate> certificateChain;

    private SigningCredential(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = Collections.unmodifiableList(certificateChain);
    }

    public static SigningCredential create(PrivateKey privateKey, X509Certificate ... certificateChain) {
        return SigningCredential.create(privateKey, Iterables.newImmutableList(certificateChain));
    }

    public static SigningCredential create(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        SigningCredential.validateInput(privateKey, certificateChain);
        return new SigningCredential(privateKey, certificateChain);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    private static void validateInput(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        if (privateKey == null) {
            throw new IllegalArgumentException("The given private key cannot be null");
        }
        if (certificateChain == null || certificateChain.isEmpty()) {
            throw new IllegalArgumentException("The given certificate chain cannot be null or empty");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SigningCredential)) {
            return false;
        }
        SigningCredential otherCredential = (SigningCredential)obj;
        return ((Object)this.certificateChain).equals(otherCredential.certificateChain);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.certificateChain});
    }
}

