﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.signature.domain;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.vlaanderen.mercurius.insurability.schemas.v1;
using be.vlaanderen.mercurius.mohm.schemas.v1;
using java.util;
using java.util.concurrent;
using NUnit.Framework;
using org.apache.commons.lang3;
using org.slf4j;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNetGenericAsyncMethod
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(VsbNetGenericAsyncMethod));
		
		private static int SECONDS_WAITING = 60;

	    /******************
	     *
	     * POST Methods
	     *
	     *******************/
	
	    public static void do_POST_CreateApplication(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.createApplication((EMOHMDF101CreateApplicationRequest)ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                             typeof(EMOHMDF101CreateApplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateApplication(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_CreateApplicationV3 (String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.createApplicationV3((be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                               typeof(be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateApplicationV3(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateApplicationV3(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_CreateFictionalApplication(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.createFictionalApplication((EMOHMDF102CreateFictionalApplicationRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                                      typeof(EMOHMDF102CreateFictionalApplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateFictionalApplication(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultHistory(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.consultHistory((be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryRequest)ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                          typeof(be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultHistory(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultHistory(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	    
	    public static void do_POST_ConsultApplication(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.consultApplication((EMOHMDF103ConsultapplicationRequest) ConnectorXmlUtils
	                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                              typeof(EMOHMDF103ConsultapplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getConsultApplication(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultApplicationV4(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.consultApplicationV4((be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                                typeof(be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultApplicationV4(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultApplicationV4(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultSupportAndRepair(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.consultSupportAndRepair((EMOHMDF104ConsultSupportAndRepairRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                                   typeof(EMOHMDF104ConsultSupportAndRepairRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepair(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultSupportAndRepairV4(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.consultSupportAndRepairV4((be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                                     typeof(be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairV4(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairV4(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ReportDelivery(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService()
	        	.reportDelivery((EMOHMDF105ReportDeliveryRequest)ConnectorXmlUtils
	                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                          typeof(EMOHMDF105ReportDeliveryRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getReportDelivery(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_CancelApplication(String requestLocation) {
	    	ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().cancelApplication( (EMOHMDF111CancelApplicationRequest) ConnectorXmlUtils
	            .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	                typeof(EMOHMDF111CancelApplicationRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCancelApplication(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCancelApplication(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultSupportAndRepairList(String requestLocation) {
	    	ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().consultSupportAndRepairList( (EMOHMDF112ConsultSupportAndRepairListRequest) ConnectorXmlUtils
	                .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	                        typeof(EMOHMDF112ConsultSupportAndRepairListRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getConsultSupportAndRepairList(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getConsultSupportAndRepairList(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_ConsultSupportAndRepairListV2(String requestLocation) {
	    	ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().consultSupportAndRepairListV2((be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListRequest) ConnectorXmlUtils
	            .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation), typeof(be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_RefusedInvoice(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(requestLocation), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
	        validateXadesTOfTAckResponseWithManifest(processedPostResponse, response);
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceFileRefused(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_AcceptedInvoice(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .postInvoiceList(ConnectorIOUtils.getResourceAsByteArray(requestLocation), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceFileAccepted(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
	        confirmTacks(response);
	        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted1(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	        response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted2(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    public static void do_POST_DetermineInsurability(String requestLocation) {
	        ProcessedPostResponse processedPostResponse = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
	        	.determineInsurability((WZCMHDF001DetermineInsurabilityRequest) ConnectorXmlUtils
	                        .toObject(ConnectorIOUtils.getResourceAsByteArray(requestLocation),
	        	                                 typeof(WZCMHDF001DetermineInsurabilityRequest)), generateInputReference());
	        String reference = processedPostResponse.getPostResponse().getReturn().getReference();
	        waitForTack();
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
	                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
	        confirmTack((ProcessedTAckResponse) response.getTAckResponses().get(0));
	        response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
	                .getDetermineInsurability(GetRequest.newBuilder().withReference(reference).build());
	        assertTackRemoved(response.getTAckResponses());
	    }
	
	    /******************
	     *
	     * GET Methods
	     *
	     *******************/
	
	    public static void do_GET_CreateApplication(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getCreateApplication(GetRequest.newBuilder().withDefaults().build());
	
	        assertCreateApplication(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_CreateApplicationV3(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateApplicationV3(GetRequest.newBuilder().withDefaults().build());
	
	        assertCreateApplicationV3(responseLocation, response);
	
	       
	    }
	
	    public static void do_GET_CreateFictionalApplication(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getCreateFictionalApplication(GetRequest.newBuilder().withDefaults().build());
	
	        assertCreateFictionalApplication(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultHistory(String responseLocation, Boolean toConfirm) {
	
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultHistory(GetRequest.newBuilder().withDefaults().build());
	        
	        assertConsultHistory(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	    
	    public static void do_GET_ConsultApplication(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultApplication(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultApplication(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultApplicationV4(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultApplicationV4(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultApplicationV4(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultSupportAndRepair(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepair(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultSupportAndRepair(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultSupportAndRepairV4(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairV4(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultSupportAndRepairV4(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ReportDelivery(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getReportDelivery(GetRequest.newBuilder().withDefaults().build());
	
	        assertReportDelivery(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_PushDecision(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getPushDecision(GetRequest.newBuilder().withDefaults().build());
	
	        assertPushDecision(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_PushDecisionV4(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getPushDecisionV4(GetRequest.newBuilder().withDefaults().build());
	
	        assertPushDecisionV4(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	    
	    public static void do_GET_PushApplicationView(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getPushApplicationView(GetRequest.newBuilder().withDefaults().build());
	
	        assertPushApplicationView(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_PushApplicationViewV4(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getPushApplicationViewV4(GetRequest.newBuilder().withDefaults().build());
	
	        assertPushApplicationViewV4(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_CancelApplication(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getCancelApplication(GetRequest.newBuilder().withDefaults().build());
	
	        assertCancelApplication(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultSupportAndRepairList(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	                .getConsultSupportAndRepairList(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultSupportAndRepairList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ConsultSupportAndRepairListV2(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetMohmService()
	            .getConsultSupportAndRepairListV2(GetRequest.newBuilder().withDefaults().build());
	
	        assertConsultSupportAndRepairListV2(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ListInvoiceFileAccepted(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceFileAccepted(GetRequest.newBuilder().withDefaults().build());
	
	        assertInvoiceList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ListInvoiceAccepted1(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted1(GetRequest.newBuilder().withDefaults().build());
	
	        assertInvoiceList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ListInvoiceAccepted2(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceAccepted2(GetRequest.newBuilder().withDefaults().build());
	
	        assertInvoiceList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ListInvoiceRefused(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceRefused(GetRequest.newBuilder().withDefaults().build());
	
	        assertInvoiceList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_ListInvoiceFileRefused(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse response = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	                .getListInvoiceFileRefused(GetRequest.newBuilder().withDefaults().build());
	
	        assertInvoiceList(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    public static void do_GET_DetermineInsurability(String responseLocation, Boolean toConfirm) {
	        ProcessedGetResponse
	        	response = VsbNetSessionServiceFactory.getVsbNetInsurabilityService()
	                .getDetermineInsurability(GetRequest.newBuilder().withDefaults().build());
	
	        assertDetermineInsurability(responseLocation, response);
	
	        if (toConfirm) {
	            ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(response);
	            Assert.NotNull(confirmResponse);
	        }
	    }
	
	    /******************
	     *
	     * Test assertions
	     *
	     *******************/
	
	    private static void assertCreateApplication(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF101CreateApplicationResponse expected = (EMOHMDF101CreateApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF101CreateApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF101CreateApplicationResponse businessResponse = (EMOHMDF101CreateApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertCreateApplicationV3(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse expected = (be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse businessResponse = (be.vlaanderen.mercurius.mohm.df101.v3.EMOHMDF101CreateApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertCreateFictionalApplication(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF102CreateFictionalApplicationResponse expected = (EMOHMDF102CreateFictionalApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF102CreateFictionalApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF102CreateFictionalApplicationResponse businessResponse = (EMOHMDF102CreateFictionalApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertConsultHistory(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse expected = (be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse businessResponse = (be.vlaanderen.mercurius.mohm.df102.v3.EMOHMDF102ConsultHistoryResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	    
	    private static void assertConsultApplication(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF103ConsultApplicationResponse expected = (EMOHMDF103ConsultApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF103ConsultApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF103ConsultApplicationResponse businessResponse = (EMOHMDF103ConsultApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertConsultApplicationV4(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse expected = (be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse businessResponse = (be.vlaanderen.mercurius.mohm.df103.v4.EMOHMDF103ConsultApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertConsultSupportAndRepair(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF104ConsultSupportAndRepairResponse expected = (EMOHMDF104ConsultSupportAndRepairResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF104ConsultSupportAndRepairResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF104ConsultSupportAndRepairResponse businessResponse = (EMOHMDF104ConsultSupportAndRepairResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertConsultSupportAndRepairV4(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse expected = (be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse businessResponse = (be.vlaanderen.mercurius.mohm.df104.v4.EMOHMDF104ConsultSupportAndRepairResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertReportDelivery(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF105ReportDeliveryResponse expected = (EMOHMDF105ReportDeliveryResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF105ReportDeliveryResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF105ReportDeliveryResponse businessResponse = (EMOHMDF105ReportDeliveryResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertPushDecision(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF106PushDecisionRequest expected = (EMOHMDF106PushDecisionRequest) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF106PushDecisionRequest));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF106PushDecisionRequest businessResponse = (EMOHMDF106PushDecisionRequest) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	
	    }
	
	    private static void assertPushDecisionV4(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest expected = (be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest businessResponse = (be.vlaanderen.mercurius.mohm.df106.v4.EMOHMDF106PushDecisionRequest) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertPushApplicationView(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF107PushApplicationViewRequest expected = (EMOHMDF107PushApplicationViewRequest) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF107PushApplicationViewRequest));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF107PushApplicationViewRequest businessResponse = (EMOHMDF107PushApplicationViewRequest) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	
	    }
	
	    private static void assertPushApplicationViewV4(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest
	        	expected = (be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest businessResponse = (be.vlaanderen.mercurius.mohm.df107.v4.EMOHMDF107PushApplicationViewRequest) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	    
	    private static void assertCancelApplication(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF111CancelApplicationResponse expected = (EMOHMDF111CancelApplicationResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF111CancelApplicationResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF111CancelApplicationResponse businessResponse = (EMOHMDF111CancelApplicationResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertConsultSupportAndRepairList(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        EMOHMDF112ConsultSupportAndRepairListResponse expected = (EMOHMDF112ConsultSupportAndRepairListResponse) ConnectorXmlUtils.toObject(expectedString, typeof(EMOHMDF112ConsultSupportAndRepairListResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	EMOHMDF112ConsultSupportAndRepairListResponse businessResponse = (EMOHMDF112ConsultSupportAndRepairListResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	            if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	
	    }
	
	    private static void assertConsultSupportAndRepairListV2(String expectedResponse, ProcessedGetResponse response) {
	        String expectedString = ConnectorIOUtils.getResourceAsString(expectedResponse);
	        be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse
	        	expected = (be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse) ConnectorXmlUtils.toObject(expectedString, typeof(be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse));
	        for (int i = response.getMsgResponses().size() -1; i >=0; i--) {
	        	be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse businessResponse = (be.vlaanderen.mercurius.mohm.df112.v2.EMOHMDF112ConsultSupportAndRepairListResponse) ((ProcessedMsgResponse) response.getMsgResponses().get(i)).getBusinessResponse();
	           if (matchesMetadata(expected.getMessageMetadata(), businessResponse.getMessageMetadata())) {
	                XmlAsserter.assertSimilar(expectedString, ConnectorXmlUtils.toString(businessResponse));
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	
	    private static void assertInvoiceList(String expectedResponse, ProcessedGetResponse response) {
	        byte[] expected = ConnectorIOUtils.getResourceAsByteArray(expectedResponse);
	        for (int i=0; i < response.getMsgResponses().size(); i++) {
	        	ProcessedMsgResponse processedMsgResponse = (ProcessedMsgResponse) response.getMsgResponses().get(i);
	        	
	        	Assert.AreEqual(System.Text.Encoding.Default.GetString(expected), System.Text.Encoding.Default.GetString((byte[]) processedMsgResponse.getBusinessResponse()));
	            Assert.AreEqual(0, processedMsgResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
	            Assert.NotNull(processedMsgResponse.getMsgResponse().getXadesT(), "Missing xades");
	            Assert.IsTrue(Arrays.equals((byte[]) processedMsgResponse.getBusinessResponse(), processedMsgResponse.getSignedData()),"Signed data and businessResponse content do not match");
	        }
	    }
	
	    private static void assertDetermineInsurability(String expectedResponse, ProcessedGetResponse response) {
	    	WZCMHDF001DetermineInsurabilityResponse expected = (WZCMHDF001DetermineInsurabilityResponse) ConnectorXmlUtils.toObject(ConnectorIOUtils.getResourceAsString(expectedResponse), typeof(WZCMHDF001DetermineInsurabilityResponse));
	    	for (int i=0; i < response.getMsgResponses().size() ; i = 0) {
	    		ProcessedMsgResponse processedMsgResponse = (ProcessedMsgResponse) response.getMsgResponses().get(i);
	    		WZCMHDF001DetermineInsurabilityResponse businessResponse = (WZCMHDF001DetermineInsurabilityResponse) processedMsgResponse.getBusinessResponse();
	            if (expected.getMessageMetadata().getCareProviderReference().Equals(businessResponse.getMessageMetadata().getCareProviderReference())) {
	                XmlAsserter.assertSimilar(expected, businessResponse);
	                return;
	            }
	        }
	        failNoMessageResponse();
	    }
	    
	    private static Boolean matchesMetadata(be.vlaanderen.mercurius.mohm.schemas.v1.MessageMetadataType expected,
                                                   be.vlaanderen.mercurius.mohm.schemas.v1.MessageMetadataType actual) {
                return StringUtils.equals(expected.getSSIN(), actual.getSSIN()) &&
                        StringUtils.equals(expected.getEnterpriseNumber(), actual.getEnterpriseNumber()) &&
                        StringUtils.equals(expected.getCareProviderReference(), actual.getCareProviderReference());
            }
        
        private static Boolean matchesMetadata(be.vlaanderen.mercurius.mohm.common.v7.MessageMetadataType expected,
                                               be.vlaanderen.mercurius.mohm.common.v7.MessageMetadataType actual) {
            return StringUtils.equals(expected.getSSIN(), actual.getSSIN()) &&
                    StringUtils.equals(expected.getEnterpriseNumber(), actual.getEnterpriseNumber()) &&
                    StringUtils.equals(expected.getCareProviderReference(), actual.getCareProviderReference());
        }
	    
	    private static void failNoMessageResponse() {
	        Assert.Fail("No message reponse");
	    }
	
	    private static void confirmMsgResponses(ProcessedGetResponse processedGetResponse) {
	        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllMessages(processedGetResponse);
	        Assert.NotNull(confirmResponse);
	    }
	
	    private static void assertTackRemoved(java.util.List tAckResponses) {
	        Assert.AreEqual( 0, tAckResponses.size(), "Tack should be removed");
	    }
	
	    private static void confirmTacks(ProcessedGetResponse processedGetResponse) {
	        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmAllTAcks(processedGetResponse);
	        Assert.NotNull(confirmResponse);
	    }
	
	    private static void confirmTack(ProcessedTAckResponse processedTAckResponse) {
	        ConfirmResponse confirmResponse = VsbNetSessionServiceFactory.getVsbNetMohmService().confirmTAck(processedTAckResponse);
	        Assert.NotNull(confirmResponse);
	    }
	
	    private static void waitForTack() {
	        TimeUnit.SECONDS.sleep(SECONDS_WAITING);
	    }
	
	    private static InputReference generateInputReference() {
	        return new InputReference();
	    }
	
	    private static void validateXadesTOfTAckResponseWithManifest(ProcessedPostResponse processedPostResponse, ProcessedGetResponse response) {
	        SignatureVerificationResult signatureVerificationResult = VsbNetSessionServiceFactory.getVsbNetInvoiceService()
	        	.validateXadesTWithManifest(
	        		((ProcessedTAckResponse) response.getTAckResponses().get(0)).getTAckResponse(),
	        		processedPostResponse.getPost().getDetail(), 
	        		((ProcessedTAckResponse) response.getTAckResponses().get(0)).getTAckResponse().getXadesT().getValue());
	        Assert.IsTrue(signatureVerificationResult.getErrors().isEmpty());
	    }
	}
}
