﻿#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for KeyDepotServiceIntegrationTest
 */
namespace be.ehealth.technicalconnector.service.keydepot
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.service.keydepot;
    using be.ehealth.technicalconnector.service.keydepot.impl;
    using be.ehealth.technicalconnector.service.kgss;
    using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
    using be.fgov.ehealth.etkdepot._1_0.protocol;

    using NUnit.Framework;

    /**
     * Key Depot Service Integration Tests
     * This test shows the use of the Key Depot Service through the use of the Technical Connector
    */
    [TestFixture]
    class KeyDepotServiceIntegrationTest
    {
        #region Methods

        /**
        * Test the getEtk operation from the ETK Service through the use of the Technical Connector
        * The getEtk methods needs the following parameters:
        * - application name
        * - type of the identifier
        * - value of the identifier
        */
        [Test]
        public void testGetEtk()
        {
            /*
             * Set the values to use in this test
            */
            // The application name
            String applicationName = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.app");
            // The type of the identifier (linked to value)
            String type = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.type");
            // the value linked to the typed
            String value = TestPropertiesNetLoader.getProperties("be.ehealth.technicalconnector.test.properties",".net").getProperty("test.myEtk.value");

            /*
             * Create request
            */
            // create etk request
            ObjectFactory factory = new ObjectFactory();
            GetEtkRequest request = factory.createGetEtkRequest();

            // create the search criteria
            SearchCriteriaType searchCriteria = factory.createSearchCriteriaType();
            // the request expects a list of identifiers to get the ETK for.
            // in this example we will provide a list with 1 item.
            java.util.List listIdentifiers = new java.util.ArrayList();
            //create the identifier
            be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType identifier = factory.createIdentifierType();
            //set the application name
            identifier.setApplicationID(applicationName);
            //set the type (e.g. CBE)
            identifier.setType(type);
            //set the value associated with the type
            identifier.setValue(value);
            //add the identifier to the list
            listIdentifiers.add(identifier);
            //add the list to the search criteria
            searchCriteria.getIdentifiers().addAll(listIdentifiers);
            //add the search criteria to the request
            request.setSearchCriteria(searchCriteria);

            /*
             * Invoke the technical connector framework's ETK Service's getEtk operation
            */
            KeyDepotService service = new KeyDepotServiceImpl();
            GetEtkResponse response = service.getETK(request);

            /*
             * Verify the response
            */
            // check if the satus is ok
            Assert.AreEqual("200", response.getStatus().getCode());
            // check if an ETK is received
            Assert.IsNotNull(response.getETK());
        }

        #endregion Methods
    }
}