/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config;

import java.util.Map;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;


/**
 * Implemetation of {@link SomeBusinessInterface} needed for test purposes.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class ConfigurableImplementationImpl implements SomeBusinessInterface {

    private Map<String, Object> parameterMap;

    /**
     
     */
    @Override
    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        this.parameterMap = parameterMap;
        if (parameterMap.isEmpty()) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "missing parameters in parameterMap");
        }

    }


    /**
     * @author EHP
     */
    @Override
    public Map<String, Object> getParameterMap() {
        return parameterMap;
    }


}
