/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.mycarenetdomaincommons.helper;

import java.io.InputStream;
import java.util.List;

import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorMyCarenetType;


/**
 * test management of errors.
 * 
 * @author EH058
 * 
 * @since
 * 
 */
public class ErrorMyCarenetTypeManagementTest {

    /**
     * Test method for
     * {@link ErrorMyCarenetTypeManagement#getError(be.fgov.ehealth.messageservices.core.v1.RetrieveTransactionResponse)}
     * .
     */
    @Test
    public void testGetError() throws Exception {
        getErrors("/examples/responseHelperTestFail.xml");
    }

    /**
     * @throws TechnicalConnectorException
     */
    @SuppressWarnings({
        "unchecked", "rawtypes"
    })
    private List<ErrorMyCarenetType> getErrors(String fileName) throws TechnicalConnectorException {
        InputStream businessXmlContentStream = ConnectorIOUtils.getResourceAsStream(fileName);
        MarshallerHelper<Object, Object> responseMarshaller = new MarshallerHelper(RetrieveTransactionResponse.class, RetrieveTransactionResponse.class);
        RetrieveTransactionResponse response = (RetrieveTransactionResponse) responseMarshaller.toObject(ConnectorIOUtils.getBytes(businessXmlContentStream));
        return ErrorMyCarenetTypeManagement.getError(response);
    }

    /**
     * Test method for
     * {@link be.ehealth.utilitiesconnector.messageservices.helper.ErrorMyCarenetTypeManagement#isErrorsContainSpecificCode(java.util.List, java.lang.String[])}
     * .
     */
    @Test
    public void testIsErrorsContainSpecificCodeSuccess() throws Exception {
        List<ErrorMyCarenetType> errors = getErrors("/examples/responseHelperTestFail.xml");
        ErrorMyCarenetTypeManagement.isErrorsContainSpecificCode(errors, "111");
    }

    // /**
    // * Test method for
    // * {@link
    // be.ehealth.utilitiesconnector.messageservices.helper.ErrorMyCarenetTypeManagement#isErrorsContainSpecificCode(java.util.List,
    // java.lang.String[])}
    // * .
    // */
    // @Test
    // public void testIsErrorsContainSpecificCodeFail() throws Exception {
    // List<ErrorMyCarenetType> errors = getErrors("/examples/responseHelperTestFail.xml");
    // try {
    // ErrorMyCarenetTypeManagement.isErrorsContainSpecificCode(errors, "130");
    // Assert.fail("must have an exception");
    // } catch (Exception e) {
    // // must have an exception
    // }
    // }

    /**
     * Test method for
     * {@link be.ehealth.utilitiesconnector.messageservices.helper.ErrorMyCarenetTypeManagement#printError(be.fgov.ehealth.standards.kmehr.schema.v1.ErrorMyCarenetType)}
     * .
     */
    @Test
    public void testPrintError() throws Exception {
        List<ErrorMyCarenetType> errors = getErrors("/examples/responseHelperTestFail.xml");
        ErrorMyCarenetTypeManagement.printErrors(errors);
    }

    // /**
    // * Test method for {@link
    // be.ehealth.utilitiesconnector.messageservices.helper.ErrorMyCarenetTypeManagement#printErrors(java.util.List)}
    // * .
    // */
    // @Test
    // public void testPrintErrors() {
    // fail("Not yet implemented");
    // }

}
