/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons;

import be.ehealth.business.kmehrcommons.HcPartyUtil;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;


/**
 * tests the method {@link HcPartyUtil}.createSingleHcpartyFromConfig.
 * 
 * @author EHP
 * 
 */
public class HcPartyUtilsSingleHcpartyBuilderTest extends AbstractTestHcPartyUtils {

    @BeforeClass
    public static void init() throws Exception {
        initHcPartyUtilProperties();
    }

    @Test
    public void testMinimalHcparty() throws TechnicalConnectorException {
        checkHcpartyXml("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><HcpartyType xmlns=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\" xmlns:ns2=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\"><ns2:cd SV=\"1.1\" S=\"CD-HCPARTY\">codeIsInKmehrXsdOnlyRequiredField</ns2:cd></HcpartyType>", HcPartyUtil.createSingleHcpartyFromConfig("minimalparty"));
    }

    @Test
    public void testFullHcparty() throws TechnicalConnectorException {
        checkHcpartyXml("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><HcpartyType xmlns=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\" xmlns:ns2=\"http://www.ehealth.fgov.be/standards/kmehr/schema/v1\"><ns2:id SL=\"localType1\" SV=\"1.0\" S=\"LOCAL\">localId1</ns2:id><ns2:id SL=\"localType2\" SV=\"1.0\" S=\"LOCAL\">localId2</ns2:id><ns2:id SL=\"localType3\" SV=\"1.0\" S=\"LOCAL\">localId3</ns2:id><ns2:id SV=\"1.0\" S=\"ID-HCPARTY\">idhcparty</ns2:id><ns2:id SV=\"1.0\" S=\"INSS\">inss</ns2:id><ns2:cd SV=\"1.1\" S=\"CD-HCPARTY\">code</ns2:cd><ns2:firstname>firstname</ns2:firstname><ns2:familyname>lastname</ns2:familyname><ns2:name>name</ns2:name></HcpartyType>", HcPartyUtil.createSingleHcpartyFromConfig("fullyconfiguredparty"));
    }


}
