/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.vsbnetinsurability.service.impl;

import be.ehealth.businessconnector.vsbnetinsurability.service.ServiceFactory;
import be.ehealth.businessconnector.vsbnetinsurability.service.VSBNetInsurabilityService;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityRequest;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityResponse;
import javax.xml.soap.SOAPException;

public class VSBNetnsurabilityServiceImpl
implements VSBNetInsurabilityService {
    private SessionValidator sessionValidator;

    public VSBNetnsurabilityServiceImpl(SessionValidator sessionValidator) throws TechnicalConnectorException {
        this.sessionValidator = sessionValidator;
    }

    @Override
    public GetInsurabilityResponse getInsurability(SAMLToken token, GetInsurabilityRequest request) throws TechnicalConnectorException {
        try {
            this.sessionValidator.validateToken(token);
            GenericRequest service = ServiceFactory.getVSBInsurabilityService(token);
            service.setPayload((Object)request);
            GenericResponse xmlResponse = be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(service);
            GetInsurabilityResponse response = (GetInsurabilityResponse)xmlResponse.asObject(GetInsurabilityResponse.class);
            return response;
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

