/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

public final class DistinguishedName {
    private final LdapName distinguishedName;

    private DistinguishedName(X500Principal principal) {
        this.distinguishedName = this.createLdapName(principal);
    }

    public static DistinguishedName from(X500Principal x500Principal) {
        return new DistinguishedName(x500Principal);
    }

    public boolean hasSerialNumber() {
        String serialNumber = this.getSerialNumber();
        return serialNumber != null && !serialNumber.isEmpty();
    }

    public String getSerialNumber() {
        return this.findRdnWithType("OID.2.5.4.5");
    }

    public String getCountryCode() {
        return this.findRdnWithType("C");
    }

    public String getCommonName() {
        return this.findRdnWithType("CN");
    }

    private String findRdnWithType(String type) {
        for (Rdn rdn : this.distinguishedName.getRdns()) {
            if (!rdn.getType().equals(type)) continue;
            return rdn.getValue().toString();
        }
        return null;
    }

    private LdapName createLdapName(X500Principal principal) {
        try {
            return new LdapName(principal.getName("RFC1779"));
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException("Invalid X500Principal. Unable to build LdapName from it.", e);
        }
    }
}

