/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.dialogs;

import be.fedict.commons.eid.client.PINPurpose;
import be.fedict.commons.eid.client.spi.BeIDCardUI;
import be.fedict.commons.eid.client.spi.UserCancelledException;
import be.fedict.commons.eid.dialogs.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DefaultBeIDCardUI
implements BeIDCardUI {
    public static final int MIN_PIN_SIZE = 4;
    public static final int MAX_PIN_SIZE = 12;
    public static final int PUK_SIZE = 6;
    private static final String OPERATION_CANCELLED = "operation cancelled.";
    private Component parentComponent;
    private JFrame pinPadFrame;
    private JFrame secureReaderTransactionFrame;
    private Locale locale;
    private Messages messages;

    public DefaultBeIDCardUI() {
        this(null);
    }

    public DefaultBeIDCardUI(Messages messages) {
        this(null, messages);
    }

    public DefaultBeIDCardUI(Component parentComponent, Messages messages) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new UnsupportedOperationException("DefaultBeIDCardUI is a GUI and hence requires an interactive GraphicsEnvironment");
        }
        this.parentComponent = parentComponent;
        this.messages = messages != null ? messages : Messages.getInstance();
    }

    public void advisePINBlocked() {
        JOptionPane.showMessageDialog(this.parentComponent, this.messages.getMessage(Messages.MESSAGE_ID.PIN_BLOCKED), "eID card blocked", 0);
    }

    public void advisePINChanged() {
        JOptionPane.showMessageDialog(this.parentComponent, this.messages.getMessage(Messages.MESSAGE_ID.PIN_CHANGED), "eID PIN change", 1);
    }

    public void advisePINPadChangePIN(int retriesLeft) {
        this.showPINPadFrame(retriesLeft, "eID PIN change", this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD_CHANGE));
    }

    public void advisePINPadNewPINEntry(int retriesLeft) {
        this.showPINPadFrame(retriesLeft, "eID PIN change", this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD_MODIFY_NEW));
    }

    public void advisePINPadNewPINEntryAgain(int retriesLeft) {
        this.showPINPadFrame(retriesLeft, "eID PIN change", this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD_MODIFY_NEW_AGAIN));
    }

    public void advisePINPadOldPINEntry(int retriesLeft) {
        this.showPINPadFrame(retriesLeft, "eID PIN change", this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD_MODIFY_OLD));
    }

    public void advisePINPadOperationEnd() {
        this.disposePINPadFrame();
    }

    public void advisePINPadPINEntry(int retriesLeft, PINPurpose purpose, String applicationName) {
        if (null == applicationName) {
            this.showPINPadFrame(retriesLeft, "eID PIN", this.messages.getMessage(Messages.MESSAGE_ID.PIN_REASON, purpose.getType()), this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD));
        } else {
            this.showPINPadFrame(retriesLeft, "eID PIN", this.messages.getMessage(Messages.MESSAGE_ID.PIN_REASON, purpose.getType()), this.messages.getMessage(Messages.MESSAGE_ID.APPLICATION) + ": " + applicationName, this.messages.getMessage(Messages.MESSAGE_ID.PIN_PAD));
        }
    }

    public void advisePINPadPUKEntry(int retriesLeft) {
        this.showPINPadFrame(retriesLeft, "eID PIN unblock", this.messages.getMessage(Messages.MESSAGE_ID.PUK_PAD));
    }

    public void advisePINUnblocked() {
        JOptionPane.showMessageDialog(this.parentComponent, this.messages.getMessage(Messages.MESSAGE_ID.PIN_UNBLOCKED), "eID PIN unblock", 1);
    }

    public char[][] obtainOldAndNewPIN(int retriesLeft) {
        Box mainPanel = Box.createVerticalBox();
        if (-1 != retriesLeft) {
            mainPanel.add(Box.createVerticalStrut(4));
            Box retriesPanel = this.createWarningBox(this.messages.getMessage(Messages.MESSAGE_ID.RETRIES_LEFT) + ": " + retriesLeft);
            mainPanel.add(retriesPanel);
            mainPanel.add(Box.createVerticalStrut(24));
        }
        JPasswordField oldPinField = new JPasswordField(12);
        Box oldPinPanel = Box.createHorizontalBox();
        JLabel oldPinLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.CURRENT_PIN) + ":");
        oldPinLabel.setLabelFor(oldPinField);
        oldPinPanel.add(oldPinLabel);
        oldPinPanel.add(Box.createHorizontalStrut(5));
        oldPinPanel.add(oldPinField);
        mainPanel.add(oldPinPanel);
        mainPanel.add(Box.createVerticalStrut(5));
        JPasswordField newPinField = new JPasswordField(12);
        Box newPinPanel = Box.createHorizontalBox();
        JLabel newPinLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.NEW_PIN) + ":");
        newPinLabel.setLabelFor(newPinField);
        newPinPanel.add(newPinLabel);
        newPinPanel.add(Box.createHorizontalStrut(5));
        newPinPanel.add(newPinField);
        mainPanel.add(newPinPanel);
        mainPanel.add(Box.createVerticalStrut(5));
        JPasswordField new2PinField = new JPasswordField(12);
        Box new2PinPanel = Box.createHorizontalBox();
        JLabel new2PinLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.NEW_PIN) + ":");
        new2PinLabel.setLabelFor(new2PinField);
        new2PinPanel.add(new2PinLabel);
        new2PinPanel.add(Box.createHorizontalStrut(5));
        new2PinPanel.add(new2PinField);
        mainPanel.add(new2PinPanel);
        int result = JOptionPane.showOptionDialog(this.parentComponent, mainPanel, "Change eID PIN", 2, 3, null, null, null);
        if (result != 0) {
            throw new RuntimeException(OPERATION_CANCELLED);
        }
        if (!Arrays.equals(newPinField.getPassword(), new2PinField.getPassword())) {
            throw new RuntimeException("new PINs not equal");
        }
        char[] oldPin = new char[oldPinField.getPassword().length];
        char[] newPin = new char[newPinField.getPassword().length];
        System.arraycopy(oldPinField.getPassword(), 0, oldPin, 0, oldPinField.getPassword().length);
        System.arraycopy(newPinField.getPassword(), 0, newPin, 0, newPinField.getPassword().length);
        Arrays.fill(oldPinField.getPassword(), '\u0000');
        Arrays.fill(newPinField.getPassword(), '\u0000');
        return new char[][]{oldPin, newPin};
    }

    public char[] obtainPIN(int retriesLeft, PINPurpose reason, String applicationName) throws UserCancelledException {
        JPanel mainPanel = new JPanel(){
            private static final long serialVersionUID = 1L;
            private static final int BORDER_SIZE = 20;

            @Override
            public Insets getInsets() {
                return new Insets(20, 20, 20, 20);
            }
        };
        BoxLayout boxLayout = new BoxLayout(mainPanel, 3);
        mainPanel.setLayout(boxLayout);
        Box reasonPanel = Box.createHorizontalBox();
        JLabel reasonLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.PIN_REASON, reason.getType()));
        reasonPanel.add(reasonLabel);
        reasonPanel.add(Box.createHorizontalGlue());
        mainPanel.add(reasonPanel);
        mainPanel.add(Box.createVerticalStrut(16));
        if (null != applicationName) {
            Box applicationBox = Box.createHorizontalBox();
            JLabel applicationLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.APPLICATION) + ": " + applicationName);
            applicationBox.add(applicationLabel);
            applicationBox.add(Box.createHorizontalGlue());
            mainPanel.add(applicationBox);
            mainPanel.add(Box.createVerticalStrut(16));
        }
        if (-1 != retriesLeft) {
            this.addWarningBox(mainPanel, this.messages.getMessage(Messages.MESSAGE_ID.RETRIES_LEFT) + ": " + retriesLeft);
        }
        Box passwordPanel = Box.createHorizontalBox();
        JLabel promptLabel = new JLabel(this.messages.getMessage(Messages.MESSAGE_ID.LABEL_PIN) + ": ");
        passwordPanel.add(promptLabel);
        passwordPanel.add(Box.createHorizontalStrut(5));
        final JPasswordField passwordField = new JPasswordField(12);
        promptLabel.setLabelFor(passwordField);
        passwordPanel.add(passwordField);
        passwordPanel.setBorder(this.createGenerousLowerBevelBorder());
        mainPanel.add(passwordPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2)){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return new Insets(0, 0, 5, 5);
            }
        };
        final JButton okButton = new JButton(this.messages.getMessage(Messages.MESSAGE_ID.OK));
        okButton.setEnabled(false);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(this.messages.getMessage(Messages.MESSAGE_ID.CANCEL));
        buttonPanel.add(cancelButton);
        final JDialog dialog = new JDialog((Frame)null, this.messages.getMessage(Messages.MESSAGE_ID.ENTER_PIN), true);
        dialog.setAlwaysOnTop(true);
        dialog.setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)mainPanel, "Center");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        final DialogResult dialogResult = new DialogResult();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialogResult.result = DialogResult.Result.OK;
                dialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialogResult.result = DialogResult.Result.CANCEL;
                dialog.dispose();
            }
        });
        passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int pinSize = passwordField.getPassword().length;
                if (4 <= pinSize && pinSize <= 12) {
                    dialogResult.result = DialogResult.Result.OK;
                    dialog.dispose();
                }
            }
        });
        passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int pinSize = passwordField.getPassword().length;
                if (4 <= pinSize && pinSize <= 12) {
                    okButton.setEnabled(true);
                } else {
                    okButton.setEnabled(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(this.parentComponent);
        dialog.setVisible(true);
        if (dialogResult.result == DialogResult.Result.OK) {
            return passwordField.getPassword();
        }
        throw new UserCancelledException();
    }

    public char[][] obtainPUKCodes(int retriesLeft) {
        Box mainPanel = Box.createVerticalBox();
        if (-1 != retriesLeft) {
            this.addWarningBox(mainPanel, this.messages.getMessage(Messages.MESSAGE_ID.RETRIES_LEFT) + ": " + retriesLeft);
        }
        JPasswordField puk1Field = new JPasswordField(8);
        Box puk1Panel = Box.createHorizontalBox();
        JLabel puk1Label = new JLabel("eID PUK1:");
        puk1Label.setLabelFor(puk1Field);
        puk1Panel.add(puk1Label);
        puk1Panel.add(Box.createHorizontalStrut(5));
        puk1Panel.add(puk1Field);
        mainPanel.add(puk1Panel);
        mainPanel.add(Box.createVerticalStrut(5));
        JPasswordField puk2Field = new JPasswordField(8);
        Box puk2Panel = Box.createHorizontalBox();
        JLabel puk2Label = new JLabel("eID PUK2:");
        puk2Label.setLabelFor(puk2Field);
        puk2Panel.add(puk2Label);
        puk2Panel.add(Box.createHorizontalStrut(5));
        puk2Panel.add(puk2Field);
        mainPanel.add(puk2Panel);
        int result = JOptionPane.showOptionDialog(this.parentComponent, mainPanel, "eID PIN unblock", 2, 3, null, null, null);
        if (result != 0) {
            throw new RuntimeException(OPERATION_CANCELLED);
        }
        if (puk1Field.getPassword().length != 6 || puk2Field.getPassword().length != 6) {
            throw new RuntimeException("PUK size incorrect");
        }
        char[] puk1 = new char[puk1Field.getPassword().length];
        char[] puk2 = new char[puk2Field.getPassword().length];
        System.arraycopy(puk1Field.getPassword(), 0, puk1, 0, puk1Field.getPassword().length);
        System.arraycopy(puk2Field.getPassword(), 0, puk2, 0, puk2Field.getPassword().length);
        Arrays.fill(puk1Field.getPassword(), '\u0000');
        Arrays.fill(puk2Field.getPassword(), '\u0000');
        return new char[][]{puk1, puk2};
    }

    public void adviseSecureReaderOperation() {
        if (null != this.secureReaderTransactionFrame) {
            this.disposeSecureReaderFrame();
        }
        this.secureReaderTransactionFrame = new JFrame("Transaction Confirmation");
        this.secureReaderTransactionFrame.setAlwaysOnTop(true);
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 30, 10, 30);
            }
        };
        BoxLayout boxLayout = new BoxLayout(panel, 3);
        panel.setLayout(boxLayout);
        panel.add(new JLabel("Check the transaction message on the secure card reader."));
        this.secureReaderTransactionFrame.getContentPane().add(panel);
        this.secureReaderTransactionFrame.pack();
        this.secureReaderTransactionFrame.setLocationRelativeTo(this.parentComponent);
        this.secureReaderTransactionFrame.setVisible(true);
    }

    public void adviseSecureReaderOperationEnd() {
        this.disposeSecureReaderFrame();
    }

    private Box addWarningBox(JComponent parent, String warningMessage) {
        parent.add(Box.createVerticalStrut(4));
        Box retriesPanel = this.createWarningBox(warningMessage);
        parent.add(retriesPanel);
        parent.add(Box.createVerticalStrut(24));
        return retriesPanel;
    }

    private Box createWarningBox(String warningText) {
        Box warningBox = Box.createHorizontalBox();
        JLabel warningLabel = new JLabel(warningText);
        warningLabel.setForeground(Color.RED);
        Icon warningIcon = UIManager.getIcon("OptionPane.warningIcon");
        if (warningIcon != null) {
            warningLabel.setIcon(warningIcon);
        }
        warningBox.add(warningLabel);
        warningBox.add(Box.createHorizontalGlue());
        warningBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red, 1), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        return warningBox;
    }

    private Border createGenerousLowerBevelBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(16, 16, 16, 16));
    }

    private void showPINPadFrame(int retriesLeft, String title, String ... messages) {
        if (null != this.pinPadFrame) {
            this.disposePINPadFrame();
        }
        this.pinPadFrame = new JFrame(title);
        this.pinPadFrame.setAlwaysOnTop(true);
        this.pinPadFrame.setResizable(false);
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 3);
        panel.setLayout(boxLayout);
        panel.setBorder(BorderFactory.createEmptyBorder(32, 32, 32, 32));
        if (messages.length > 0) {
            JLabel label = new JLabel(messages[0]);
            label.setAlignmentX(0.5f);
            panel.add(label);
        }
        if (-1 != retriesLeft) {
            panel.add(Box.createVerticalStrut(24));
            Box warningBox = this.createWarningBox(this.messages.getMessage(Messages.MESSAGE_ID.RETRIES_LEFT) + ": " + retriesLeft);
            panel.add(warningBox);
            panel.add(Box.createVerticalStrut(24));
        }
        for (int i = 1; i < messages.length; ++i) {
            JLabel label = new JLabel(messages[i]);
            label.setAlignmentX(0.5f);
            panel.add(label);
        }
        this.pinPadFrame.getContentPane().add(panel);
        this.pinPadFrame.pack();
        this.pinPadFrame.setLocationRelativeTo(this.parentComponent);
        this.pinPadFrame.setVisible(true);
    }

    private void disposePINPadFrame() {
        if (null != this.pinPadFrame) {
            this.pinPadFrame.dispose();
            this.pinPadFrame = null;
        }
    }

    private void disposeSecureReaderFrame() {
        if (null != this.secureReaderTransactionFrame) {
            this.secureReaderTransactionFrame.dispose();
            this.secureReaderTransactionFrame = null;
        }
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        this.messages = Messages.getInstance(newLocale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    private static class DialogResult {
        public Result result = null;

        private DialogResult() {
        }

        static enum Result {
            OK,
            CANCEL;

        }
    }
}

