/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.consumer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum DocumentType implements Serializable
{
    BELGIAN_CITIZEN("1"),
    KIDS_CARD("6"),
    BOOTSTRAP_CARD("7"),
    HABILITATION_CARD("8"),
    FOREIGNER_A("11", "33"),
    FOREIGNER_B("12", "34"),
    FOREIGNER_C("13"),
    FOREIGNER_D("14"),
    FOREIGNER_E("15"),
    FOREIGNER_E_PLUS("16"),
    FOREIGNER_F("17", "35"),
    FOREIGNER_F_PLUS("18", "36"),
    EUROPEAN_BLUE_CARD_H("19"),
    FOREIGNER_I("20"),
    FOREIGNER_J("21"),
    FOREIGNER_M("22"),
    FOREIGNER_N("23"),
    FOREIGNER_K("27"),
    FOREIGNER_L("28"),
    FOREIGNER_EU("31"),
    FOREIGNER_EU_PLUS("32");

    private final Set<Integer> keys = new HashSet<Integer>();
    private static Map<Integer, DocumentType> documentTypes;

    private DocumentType(String ... valueList) {
        for (String value : valueList) {
            this.keys.add(this.toKey(value));
        }
    }

    private int toKey(String value) {
        char c1 = value.charAt(0);
        int key = c1 - 48;
        if (2 == value.length()) {
            key *= 10;
            char c2 = value.charAt(1);
            key += c2 - 48;
        }
        return key;
    }

    private static int toKey(byte[] value) {
        int key = value[0] - 48;
        if (2 == value.length) {
            key *= 10;
            key += value[1] - 48;
        }
        return key;
    }

    public static DocumentType toDocumentType(byte[] value) {
        int key = DocumentType.toKey(value);
        DocumentType documentType = documentTypes.get(key);
        return documentType;
    }

    public static String toString(byte[] documentTypeValue) {
        return Integer.toString(DocumentType.toKey(documentTypeValue));
    }

    static {
        HashMap<Integer, DocumentType> documentTypes = new HashMap<Integer, DocumentType>();
        for (DocumentType documentType : DocumentType.values()) {
            for (Integer key : documentType.keys) {
                if (documentTypes.containsKey(key)) {
                    throw new RuntimeException("duplicate document type enum: " + key);
                }
                documentTypes.put(key, documentType);
            }
        }
        DocumentType.documentTypes = documentTypes;
    }
}

