/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.mappers;

import be.ehealth.business.kmehrcommons.HcPartyUtil;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.fgov.ehealth.hubservices.core.v2.HCPartyIdType;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTY;
import be.fgov.ehealth.standards.kmehr.cd.v1.CDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HcPartyMapper {
    private static final String APPLICATION = "application_ID";
    private static final String IDVERSION = "1.0";

    public static HcParty mapHcParty(HcpartyType hcpartyType) {
        HcParty mappedParty = new HcParty();
        mappedParty.setName(hcpartyType.getName());
        mappedParty.setFamilyName(hcpartyType.getFamilyname());
        mappedParty.setFirstName(hcpartyType.getFirstname());
        mappedParty.setCds(hcpartyType.getCds());
        mappedParty.setIds(hcpartyType.getIds());
        mappedParty.setType(((CDHCPARTY)hcpartyType.getCds().get(0)).getValue());
        return mappedParty;
    }

    public static HCPartyIdType mapHcPartyIdType(HcParty hcp) throws TherLinkBusinessConnectorException {
        HCPartyIdType hcpIdType = new HCPartyIdType();
        hcpIdType.setFamilyname(hcp.getFamilyName());
        hcpIdType.setFirstname(hcp.getFirstName());
        hcpIdType.setName(hcp.getName());
        hcpIdType.getIds().addAll(HcPartyMapper.mapIdsAndPropertiesToIdList(hcp));
        hcpIdType.setCd(HcPartyMapper.createHcPartyType(hcp.getType()));
        return hcpIdType;
    }

    public static HcpartyType mapToHcpartyType(HcParty hcp) throws TherLinkBusinessConnectorException {
        HcpartyType hcpType = new HcpartyType();
        hcpType.setFamilyname(hcp.getFamilyName());
        hcpType.setFirstname(hcp.getFirstName());
        hcpType.setName(hcp.getName());
        hcpType.getIds().addAll(HcPartyMapper.mapIdsAndPropertiesToIdList(hcp));
        CDHCPARTY cd = HcPartyMapper.createHcPartyType(hcp.getType());
        hcpType.getCds().add(cd);
        return hcpType;
    }

    private static Collection<? extends IDHCPARTY> mapIdsAndPropertiesToIdList(HcParty hcp) {
        IDHCPARTY ehp;
        IDHCPARTY idApplication;
        IDHCPARTY idCbe;
        IDHCPARTY idNihii;
        IDHCPARTY idInss;
        ArrayList<IDHCPARTY> result = new ArrayList<IDHCPARTY>();
        if (hcp.getIds() != null) {
            result.addAll(hcp.getIds());
        }
        if (hcp.getInss() != null && !HcPartyMapper.verifyListIfIDExists(result, idInss = HcPartyUtil.buildId((String)IDVERSION, (String)hcp.getInss(), (IDHCPARTYschemes)IDHCPARTYschemes.INSS, null))) {
            result.add(idInss);
        }
        if (hcp.getNihii() != null && !HcPartyMapper.verifyListIfIDExists(result, idNihii = HcPartyUtil.buildId((String)IDVERSION, (String)hcp.getNihii(), (IDHCPARTYschemes)IDHCPARTYschemes.ID_HCPARTY, null))) {
            result.add(idNihii);
        }
        if (hcp.getCbe() != null && !HcPartyMapper.verifyListIfIDExists(result, idCbe = HcPartyUtil.buildId((String)IDVERSION, (String)hcp.getCbe(), (IDHCPARTYschemes)IDHCPARTYschemes.ID_HCPARTY, null))) {
            result.add(idCbe);
        }
        if (hcp.getApplicationID() != null && !HcPartyMapper.verifyListIfIDExists(result, idApplication = HcPartyUtil.buildId((String)IDVERSION, (String)hcp.getApplicationID(), (IDHCPARTYschemes)IDHCPARTYschemes.LOCAL, (String)APPLICATION))) {
            result.add(idApplication);
        }
        if (hcp.getEHP() != null && !HcPartyMapper.verifyListIfIDExists(result, ehp = HcPartyUtil.buildId((String)IDVERSION, (String)hcp.getEHP(), (IDHCPARTYschemes)IDHCPARTYschemes.ID_HCPARTY, null))) {
            result.add(ehp);
        }
        return result;
    }

    private static boolean verifyListIfIDExists(List<IDHCPARTY> ids, IDHCPARTY idToVerify) {
        for (IDHCPARTY existingId : ids) {
            if (!HcPartyMapper.areIdsTheSame(idToVerify, existingId)) continue;
            return true;
        }
        return false;
    }

    private static boolean areIdsTheSame(IDHCPARTY idToVerify, IDHCPARTY existingId) {
        boolean stheSame = HcPartyMapper.isTheSame(existingId.getS(), idToVerify.getS());
        boolean slTheSame = HcPartyMapper.isTheSame(existingId.getSL(), idToVerify.getSL());
        boolean valueTheSame = HcPartyMapper.isTheSame(existingId.getValue(), idToVerify.getValue());
        return stheSame && slTheSame && valueTheSame;
    }

    private static boolean isTheSame(Object existing, Object toVerify) {
        return existing == null && toVerify == null || existing != null && toVerify != null && existing.equals(toVerify);
    }

    private static CDHCPARTY createHcPartyType(String type) {
        String tempType = type;
        if (tempType != null) {
            tempType = tempType.trim();
        }
        return HcPartyUtil.buildCd((String)"1.1", (String)tempType, (CDHCPARTYschemes)CDHCPARTYschemes.CD_HCPARTY, null);
    }
}

