/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.validator.impl.handler;

import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XOPValidationHandler
extends DefaultHandler {
    private boolean xop;
    private int endElementAfterXOP;
    private boolean enabled;

    public XOPValidationHandler(boolean enable) {
        this.enabled = enable;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.enabled) {
            this.resetXOP();
            if ("Include".equals(localName) && "http://www.w3.org/2004/08/xop/include".equals(uri) && attributes.getValue("href") != null) {
                this.xop = true;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String content;
        if (this.xop && StringUtils.isNotBlank((CharSequence)(content = StringUtils.substring((String)new String(ch), (int)start, (int)(start + length))))) {
            this.xop = false;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.xop) {
            ++this.endElementAfterXOP;
        }
    }

    public boolean isXop() {
        return this.xop;
    }

    private void resetXOP() {
        if (this.endElementAfterXOP == 2) {
            this.xop = false;
            this.endElementAfterXOP = 0;
        }
    }
}

