package be.ehealth.technicalconnector.validator;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import javax.xml.validation.ValidatorHandler;

/**
 * ValidatorHelper test to verify behaviour.
 *
 * @author EHP
 */
public class ValidatorHelperTest {

    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void existingSchemaLocationManualLoadingDependencies() throws Exception {
        ValidatorHandler handler = ValidatorHelper.createValidatorForSchemaFiles(
                "/ehealth-commons/XSD/ehealth-commons-schema-core-1_0.xsd",
                "/ehealth-commons/XSD/ehealth-commons-schema-protocol-1_0.xsd",
                "/ehealth-etee/XSD/ehealth-etkdepot-schema-protocol-1_0.xsd");
        Assert.assertNotNull(handler);
    }

    @Test
    public void existingSchemaLocationAutoLoadingDependencies() throws Exception {
        ValidatorHandler handler = ValidatorHelper.createValidatorForSchemaFiles("/ehealth-etee/XSD/ehealth-etkdepot-schema-protocol-1_0.xsd");
        Assert.assertNotNull(handler);
    }

    @Test
    public void unExistingSchemaLocation() throws Exception {
        expectedException.expect(TechnicalConnectorException.class);
        expectedException.expectMessage("/ehealth-etee/XSD/ehealth-etkdepot-schema-protocol-1_1.xsd");

        ValidatorHandler handler = ValidatorHelper.createValidatorForSchemaFiles("/ehealth-etee/XSD/ehealth-etkdepot-schema-protocol-1_1.xsd");
        Assert.assertNotNull(handler);
    }

    @Test
    public void unExistingSchemaLocations() throws Exception {
        expectedException.expect(TechnicalConnectorException.class);
        expectedException.expectMessage("/unexisting/xsd");

        ValidatorHandler handler = ValidatorHelper.createValidatorForSchemaFiles("/ehealth-etee/XSD/ehealth-etkdepot-schema-protocol-1_0.xsd", "/unexisting/xsd");
        Assert.assertNotNull(handler);
    }
}