/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.adapter;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Unit test for {@link XmlDateAdapter}
 *
 * @author Olivier Chapuis (eh077))
 */
public class XmlDateAdapterTest {

    @Test
    public void testDateCreatedInOtherTimezone() throws Exception {
        XmlDateAdapter xmlDateAdapter = new XmlDateAdapter();
        DateTime parsedDateTimeZonePlusOneJanuary = xmlDateAdapter.unmarshal("2013-01-01+01:00");
        DateTime parsedDateTimeZonePlusOneMay = xmlDateAdapter.unmarshal("2013-05-01+01:00");

        Assert.assertEquals("2013-01-01+01:00", xmlDateAdapter.marshal(parsedDateTimeZonePlusOneJanuary));
        Assert.assertEquals("2013-05-01+01:00", xmlDateAdapter.marshal(parsedDateTimeZonePlusOneMay)); // loses the timezone
    }

    @Test
    public void testDatesCreatedInDifferentTimesOfYear() throws Exception {
        XmlDateAdapter xmlDateAdapter = new XmlDateAdapter();
        XmlDateTimeAdapter xmlDateTimeAdapter = new XmlDateTimeAdapter();
        DateTime parsedDateTimeZonePlusOneSeptember = xmlDateTimeAdapter.unmarshal("2000-09-09+01:00");
        DateTime parsedDateTimeZonePlusTwoSeptember = xmlDateTimeAdapter.unmarshal("2000-09-09+02:00");
        DateTime parsedDateTimeZonePlusOneDecember = xmlDateTimeAdapter.unmarshal("2000-12-09+01:00");

        // loses the timezone
        Assert.assertEquals("2000-12-09+01:00", xmlDateAdapter.marshal(parsedDateTimeZonePlusOneDecember));

        // loses the timezone
        Assert.assertEquals("2000-09-09+01:00", xmlDateAdapter.marshal(parsedDateTimeZonePlusOneSeptember));

        // can swith dates if date is different in current timezone
        Assert.assertEquals("2000-09-09+02:00", xmlDateAdapter.marshal(parsedDateTimeZonePlusTwoSeptember));
    }

    @Test
    public void testPrintDateNull() throws Exception {
        Assert.assertNull(new XmlDateAdapter().marshal(null));
    }
    
}
