package be.ehealth.businessconnector.test.vsbnet.async.session;

import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * @author EHP
 */
@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class VsbNet_eMOHDF112_V2_IntegrationTest {

    private static final String FILES_FOLDER = "/examples/vsbnet/async/eHMOHDF112_V2/";

    // Prerequisites :
    // 1 - Execute the two first test 5_1a and 5_1b
    // 2 - Get the VSBReference returned in 5_1b and replace the old one in the following xml files
    // 3 - Ask a validation of the vsb reference before 5_1c and 5_3c : this is mandatory to have the correct result
    // 4 - Execute the other tests
    
    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.vsbnet.test.properties").build();
    
    @Test
    public void test_5_01a_POST_CreateApplicationV3() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_CreateApplicationV3(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvraag_rolstoel_request.xml");
    }

    @Test
    public void test_5_01b_GET_CreateApplicationV3() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_CreateApplicationV3(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvraag_rolstoel_response.xml", false);
    }

    // Need a manuel intervention in order to have a correct result : send the vsb reference returned in the previous test
    @Test
    public void test_5_01c_GET_PushDecisionV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvaarde_beslissing_aanvraag_rolstoel.xml", false);
    }

    @Test
    public void test_5_02a_POST_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_2_consultatie_supportandrepair_testlink_eWZC-3113_request.xml");
    }

    @Test
    public void test_5_02b_GET_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_2_consultatie_supportandrepair_testlink_eWZC-3113_response.xml", false);
    }

    @Test
    public void test_5_03a_POST_ReportDelivery() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_3_aflevering_rolstoel_request.xml");
    }

    @Test
    public void test_5_03b_GET_ReportDelivery() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_3_aflevering_rolstoel_response.xml", false);
    }

    @Test
    public void test_5_03c_GET_PushDecisionV4() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_PushDecisionV4(FILES_FOLDER + "vsb-mohm_DF112_5_3_aanvaarde_beslissing_aflevering_rolstoel.xml", false);
    }

    @Test
    public void test_5_04a_POST_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_4_consultatie_supportandrepair_testlink_eWZC-3114_request.xml");
    }

    @Test
    public void test_5_04b_GET_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_4_consultatie_supportandrepair_testlink_eWZC-3114_response.xml", false);
    }

    @Test
    public void test_5_05a_POST_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_5_consultatie_supportandrepair_testlink_eWZC-3115_request.xml");
    }

    @Test
    public void test_5_05b_GET_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_5_consultatie_supportandrepair_testlink_eWZC-3115_response.xml", false);
    }

    @Test
    public void test_5_06a_POST_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_6_consultatie_supportandrepair_testlink_eWZC-3116_request.xml");
    }

    @Test
    public void test_5_06b_GET_ConsultSupportAndRepairListV2() throws Exception {
        VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairListV2(FILES_FOLDER + "vsb-mohm_DF112_5_6_consultatie_supportandrepair_testlink_eWZC-3116_response.xml", false);
    }
}
