/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.vsbnetinsurability.builder.impl;

import be.ehealth.business.mycarenetcommons.builders.util.BlobUtil;
import be.ehealth.business.mycarenetcommons.v3.mapper.SendRequestMapper;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.vsbnetinsurability.builder.RequestBuilder;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.fgov.ehealth.mycarenet.commons.core.v3.BlobType;
import be.fgov.ehealth.vsb.insurability.protocol.v1.GetInsurabilityRequest;
import org.joda.time.DateTime;

public class RequestBuilderImpl
implements RequestBuilder {
    private static final String PROJECT_IDENTIFIER = "mcn.vsbnetinsurability";

    @Override
    public GetInsurabilityRequest buildGetInsurabilityRequest(CommonInput commonInput, Routing routing, Blob blob) throws TechnicalConnectorException {
        GetInsurabilityRequest request = new GetInsurabilityRequest();
        request.setId(IdGeneratorFactory.getIdGenerator((String)"xsid").generateId());
        request.setIssueInstant(new DateTime());
        request.setCommonInput(SendRequestMapper.mapCommonInput((CommonInput)commonInput));
        request.setRouting(SendRequestMapper.mapRouting((Routing)routing));
        request.setDetail(SendRequestMapper.mapBlobToBlobType((Blob)blob));
        request.setXades(BlobUtil.generateXades((BlobType)request.getDetail(), (byte[])null, (String)PROJECT_IDENTIFIER));
        return request;
    }

    @Override
    public GetInsurabilityRequest buildGetInsurabilityRequest(Routing routing, byte[] content, String uniqueInputReference) throws TechnicalConnectorException {
        CommonInput commonInput = RequestBuilderFactory.getCommonBuilder((String)PROJECT_IDENTIFIER).createCommonInput(McnConfigUtil.retrievePackageInfo((String)PROJECT_IDENTIFIER), true, uniqueInputReference);
        Blob blob = BlobBuilderFactory.getBlobBuilder((String)PROJECT_IDENTIFIER).build(content);
        return this.buildGetInsurabilityRequest(commonInput, routing, blob);
    }
}

