/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron;

import be.fgov.ehealth.schematron.SchematronSession;
import be.fgov.ehealth.schematron.domain.SchematronConfig;
import be.fgov.ehealth.schematron.exception.InitialisationException;
import be.fgov.ehealth.schematron.impl.SchematronSessionImpl;

public final class SchematronSessionFactory {
    public static final String JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    public static final String SAXON_TRANSFORMER_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
    private static String currentTransformerFactory;

    public static void initSaxon() throws InitialisationException {
        String saxonTransformerFactory = SAXON_TRANSFORMER_FACTORY;
        try {
            Class.forName(saxonTransformerFactory, false, SchematronSessionFactory.class.getClassLoader());
            currentTransformerFactory = System.getProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY);
            System.setProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY, saxonTransformerFactory);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(saxonTransformerFactory + " not available on classpath.");
        }
    }

    public static void stopSaxon() throws InitialisationException {
        if (currentTransformerFactory == null) {
            System.clearProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY);
        } else {
            System.setProperty(JAVAX_XML_TRANSFORM_TRANSFORMER_FACTORY, currentTransformerFactory);
        }
    }

    public static SchematronSession newInstance(SchematronConfig config) {
        return new SchematronSessionImpl(config);
    }
}

