/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.accum.AccumulatorRule;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLAccumulatorRule;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLAccumulator
extends StyleElement
implements StylesheetComponent {
    private Accumulator accumulator = new Accumulator();
    private boolean streamable;

    public Actor getActor() {
        if (this.accumulator.getDeclaringComponent() == null) {
            this.accumulator.makeDeclaringComponent(Visibility.PRIVATE, this.getContainingPackage());
        }
        return this.accumulator;
    }

    public SymbolicName getSymbolicName() {
        StructuredQName qname = this.accumulator.getAccumulatorName();
        return qname == null ? null : new SymbolicName(129, null);
    }

    public void checkCompatibility(Component component) throws XPathException {
    }

    public boolean isDeclaration() {
        return true;
    }

    public void prepareSimpleAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                String name = Whitespace.trim(atts.getValue(a));
                try {
                    this.accumulator.setAccumulatorName(this.makeQName(name));
                }
                catch (NamespaceException e) {
                    this.compileError(new XPathException(e));
                    this.accumulator.setAccumulatorName(new StructuredQName("saxon", "http://saxon.sf.net/", "error-name"));
                }
                catch (XPathException err) {
                    this.compileError("Accumulator name " + Err.wrap(name) + " is not a valid QName", err.getErrorCodeQName());
                    this.accumulator.setAccumulatorName(new StructuredQName("saxon", "http://saxon.sf.net/", "error-name"));
                }
                continue;
            }
            if (f.equals("streamable")) {
                this.accumulator.setDeclaredStreamable(false);
                this.streamable = this.processStreamableAtt(atts.getValue(a));
                this.accumulator.setDeclaredStreamable(this.streamable);
                continue;
            }
            if (!atts.getURI(a).equals("http://saxon.sf.net/") || !atts.getLocalName(a).equals("trace")) continue;
            this.accumulator.setTracing(this.processBooleanAttribute("saxon:trace", atts.getValue(a)));
        }
        if (this.accumulator.getAccumulatorName() == null) {
            this.reportAbsence("name");
        }
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name") || f.equals("streamable")) continue;
            if (f.equals("initial-value")) {
                String exp = atts.getValue(a);
                this.accumulator.setInitialValueExpression(this.makeExpression(exp, a));
                continue;
            }
            if (f.equals("as")) {
                String asAtt = atts.getValue(a);
                try {
                    SequenceType requiredType = this.makeSequenceType(asAtt);
                    this.accumulator.setType(requiredType);
                }
                catch (XPathException e) {
                    this.compileErrorInAttribute(e.getMessage(), e.getErrorCodeLocalPart(), "as");
                }
                continue;
            }
            if (atts.getURI(a).equals("http://saxon.sf.net/") && atts.getLocalName(a).equals("trace")) {
                this.accumulator.setTracing(this.processBooleanAttribute("saxon:trace", atts.getValue(a)));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.accumulator.getType() == null) {
            this.accumulator.setType(SequenceType.ANY_SEQUENCE);
        }
        if (this.accumulator.getInitialValueExpression() == null) {
            this.reportAbsence("initial-value");
            StringLiteral zls = new StringLiteral(StringValue.EMPTY_STRING);
            zls.setRetainedStaticContext(this.makeRetainedStaticContext());
            this.accumulator.setInitialValueExpression(zls);
        }
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        Configuration config = compilation.getConfiguration();
        this.accumulator.setPackageData(compilation.getPackageData());
        this.accumulator.makeDeclaringComponent(Visibility.PRIVATE, this.getContainingPackage());
        Expression init = this.accumulator.getInitialValueExpression();
        ExpressionVisitor visitor = ExpressionVisitor.make(this.getStaticContext());
        init = init.typeCheck(visitor, config.getDefaultContextItemStaticInfo());
        RoleDiagnostic role = new RoleDiagnostic(4, "xsl:accumulator-rule/select", 0);
        init = config.getTypeChecker(false).staticTypeCheck(init, this.accumulator.getType(), role, visitor);
        init = init.optimize(visitor, config.getDefaultContextItemStaticInfo());
        SlotManager stackFrameMap = new SlotManager();
        ExpressionTool.allocateSlots(init, 0, stackFrameMap);
        this.accumulator.setSlotManagerForInitialValueExpression(stackFrameMap);
        this.checkInitialStreamability(init);
        this.accumulator.addChildExpression(init);
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (!(curr instanceof XSLAccumulatorRule)) continue;
            XSLAccumulatorRule rule = (XSLAccumulatorRule)curr;
            Pattern pattern = rule.getMatch();
            Expression newValueExp = rule.getNewValueExpression(compilation, decl);
            ExpressionVisitor visitor2 = ExpressionVisitor.make(this.getStaticContext());
            newValueExp = newValueExp.typeCheck(visitor2, config.makeContextItemStaticInfo(pattern.getItemType(), false));
            RoleDiagnostic role2 = new RoleDiagnostic(4, "xsl:accumulator-rule/select", 0);
            newValueExp = config.getTypeChecker(false).staticTypeCheck(newValueExp, this.accumulator.getType(), role2, visitor2);
            newValueExp = newValueExp.optimize(visitor2, this.getConfiguration().makeContextItemStaticInfo(pattern.getItemType(), false));
            SlotManager stackFrameMap2 = new SlotManager();
            stackFrameMap2.allocateSlotNumber(new StructuredQName("", "", "value"));
            ExpressionTool.allocateSlots(newValueExp, 1, stackFrameMap2);
            boolean isPreDescent = !rule.isPostDescent();
            SimpleMode mode = isPreDescent ? this.accumulator.getPreDescentRules() : this.accumulator.getPostDescentRules();
            AccumulatorRule action = new AccumulatorRule(newValueExp, stackFrameMap2);
            mode.addRule(pattern, action, decl.getModule(), decl.getModule().getPrecedence(), 1.0, true);
            this.checkRuleStreamability(rule, pattern, newValueExp);
            ItemType itemType = pattern.getItemType();
            if (itemType instanceof NodeTest) {
                if (!itemType.getUType().overlaps(UType.DOCUMENT.union(UType.CHILD_NODE_KINDS))) {
                    rule.compileWarning("An accumulator rule that matches attribute or namespace nodes has no effect", "SXWN9999");
                }
            } else if (itemType instanceof AtomicType) {
                rule.compileWarning("An accumulator rule that matches atomic values has no effect", "SXWN9999");
            }
            this.accumulator.addChildExpression(newValueExp);
            this.accumulator.addChildExpression(pattern);
        }
        this.accumulator.getPreDescentRules().allocateAllPatternSlots();
        this.accumulator.getPostDescentRules().allocateAllPatternSlots();
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            String nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-accumulator" + this.generateId());
            }
            try {
                qn = this.makeQName(nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-accumulator" + this.generateId());
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-accumulator" + this.generateId());
            }
        }
        return qn;
    }

    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        AccumulatorRegistry mgr;
        Accumulator existing;
        if (this.accumulator.getAccumulatorName() == null) {
            this.prepareSimpleAttributes();
        }
        this.accumulator.setImportPrecedence(decl.getPrecedence());
        if (top.getAccumulatorManager() == null) {
            StyleNodeFactory styleNodeFactory = this.getCompilation().getStyleNodeFactory(true);
            AccumulatorRegistry manager = styleNodeFactory.makeAccumulatorManager();
            top.setAccumulatorManager(manager);
            this.getCompilation().getPackageData().setAccumulatorRegistry(manager);
        }
        if ((existing = (mgr = top.getAccumulatorManager()).getAccumulator(this.accumulator.getAccumulatorName())) != null) {
            int existingPrec = existing.getImportPrecedence();
            if (existingPrec == decl.getPrecedence()) {
                this.compileError("There are two accumulators with the same name (" + this.accumulator.getAccumulatorName().getDisplayName() + ") and the same import precedence", "XTSE3350");
            }
            if (existingPrec > decl.getPrecedence()) {
                return;
            }
        }
        mgr.addAccumulator(this.accumulator);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo curr;
        this.checkTopLevel("XTSE0010", true);
        boolean foundRule = false;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = kids.next()) != null) {
            if (curr instanceof XSLAccumulatorRule) {
                foundRule = true;
                continue;
            }
            this.compileError("Only xsl:accumulator-rule is allowed here", "XTSE0010");
        }
        if (!foundRule) {
            this.compileError("xsl:accumulator must contain at least one xsl:accumulator-rule", "XTSE0010");
        }
    }

    public SlotManager getSlotManager() {
        return null;
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
    }

    public SequenceType getResultType() {
        return this.accumulator.getType();
    }

    public int getConstructType() {
        return 129;
    }

    public void generateByteCode(Optimizer opt) {
    }

    private void checkInitialStreamability(Expression init) throws XPathException {
    }

    private void checkRuleStreamability(XSLAccumulatorRule rule, Pattern pattern, Expression newValueExp) throws XPathException {
    }
}

