/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.domain;

import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.commons.lang3.ArrayUtils;

public class HandlerChain {
    private Map<HandlerPosition, List<SOAPHandler<?>>> registeredHandlers = new EnumMap(HandlerPosition.class);

    public HandlerChain() {
        this.registeredHandlers.put(HandlerPosition.BEFORE, new ArrayList());
        this.registeredHandlers.put(HandlerPosition.SECURITY, new ArrayList());
        this.registeredHandlers.put(HandlerPosition.AFTER, new ArrayList());
    }

    public HandlerChain register(HandlerPosition position, SOAPHandler<?> handler) {
        List<SOAPHandler<?>> resultHandler = this.registeredHandlers.get((Object)position);
        resultHandler.add(handler);
        return this;
    }

    public HandlerChain unregisterHandler(HandlerPosition position, SOAPHandler<?> handler) {
        List<SOAPHandler<?>> resultHandler = this.registeredHandlers.get((Object)position);
        resultHandler.remove(handler);
        return this;
    }

    public HandlerChain add(HandlerChain handlers) {
        this.add(handlers, HandlerPosition.BEFORE);
        this.add(handlers, HandlerPosition.SECURITY);
        this.add(handlers, HandlerPosition.AFTER);
        return this;
    }

    private void add(HandlerChain handlers, HandlerPosition position) {
        this.registeredHandlers.get((Object)position).addAll(handlers.getSOAPHandlers(position));
    }

    private List<SOAPHandler<?>> getSOAPHandlers(HandlerPosition position) {
        return this.registeredHandlers.get((Object)position);
    }

    public List<Handler<?>> getHandlers(HandlerPosition position) {
        ArrayList handlers = new ArrayList();
        for (SOAPHandler<?> handler : this.registeredHandlers.get((Object)position)) {
            handlers.add((Handler<?>)handler);
        }
        return handlers;
    }

    public Handler<?>[] getHandlers() {
        Object[] handlers = new Handler[]{};
        handlers = (Handler[])ArrayUtils.addAll((Object[])handlers, (Object[])this.getHandlers(HandlerPosition.BEFORE).toArray());
        handlers = (Handler[])ArrayUtils.addAll((Object[])handlers, (Object[])this.getHandlers(HandlerPosition.SECURITY).toArray());
        handlers = (Handler[])ArrayUtils.addAll((Object[])handlers, (Object[])this.getHandlers(HandlerPosition.AFTER).toArray());
        return handlers;
    }
}

