/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.keydepot.impl;

import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotService;
import be.ehealth.technicalconnector.service.ws.ServiceFactory;
import be.ehealth.technicalconnector.utils.CertificateParser;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.commons._1_0.core.LocalisedString;
import be.fgov.ehealth.etkdepot._1_0.protocol.GetEtkRequest;
import be.fgov.ehealth.etkdepot._1_0.protocol.GetEtkResponse;
import be.fgov.ehealth.etkdepot._1_0.protocol.MatchingEtk;
import be.fgov.ehealth.etkdepot._1_0.protocol.SearchCriteriaType;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDepotServiceImpl
implements KeyDepotService,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(KeyDepotServiceImpl.class);

    private GetEtkResponse getETK(SearchCriteriaType searchCriteria) throws TechnicalConnectorException {
        GetEtkRequest request = new GetEtkRequest();
        request.setSearchCriteria(searchCriteria);
        return this.getETK(request);
    }

    @Override
    public GetEtkResponse getETK(GetEtkRequest etkRequest) throws TechnicalConnectorException {
        GenericRequest request = ServiceFactory.getETKService();
        request.setPayload(etkRequest);
        try {
            return be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(request).asObject(GetEtkResponse.class);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
    }

    private SearchCriteriaType generatedSearchCreteriaType(String identifierName, String identifierValue, String application) {
        SearchCriteriaType searchCriteria = new SearchCriteriaType();
        ArrayList<be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType> listIdentifiers = new ArrayList<be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType>();
        be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType identifier = new be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType();
        if (application != null) {
            identifier.setApplicationID(application);
        }
        identifier.setType(identifierName);
        identifier.setValue(identifierValue);
        listIdentifiers.add(identifier);
        searchCriteria.getIdentifiers().addAll(listIdentifiers);
        return searchCriteria;
    }

    @Override
    public Set<EncryptionToken> getETKSet(IdentifierType identifierType, String identifierValue, String applicationId) throws TechnicalConnectorException {
        HashSet<EncryptionToken> result = new HashSet<EncryptionToken>();
        SearchCriteriaType searchCriteria = this.generatedSearchCreteriaType(identifierType.getType(48), identifierValue, applicationId);
        GetEtkResponse response = this.getETK(searchCriteria);
        KeyDepotServiceImpl.validate(response);
        if (response.getETK() != null) {
            result.add(KeyDepotServiceImpl.toEncryptionToken(response.getETK()));
        } else if (applicationId == null && !response.getMatchingEtks().isEmpty()) {
            for (MatchingEtk matchEtk : response.getMatchingEtks()) {
                result.addAll(this.getEtk(matchEtk, identifierType, identifierValue));
            }
        } else {
            KeyDepotServiceImpl.unableToFindEtk(searchCriteria);
        }
        return result;
    }

    private Set<EncryptionToken> getEtk(MatchingEtk matchEtk, IdentifierType identifier, String id) throws TechnicalConnectorException {
        HashSet<EncryptionToken> result = new HashSet<EncryptionToken>();
        SearchCriteriaType searchType = new SearchCriteriaType();
        if (matchEtk.getIdentifiers() == null || matchEtk.getIdentifiers().size() == 0) {
            LOG.warn("Empty IdentifierList of MatchingETK");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[0]);
        }
        searchType.getIdentifiers().add(matchEtk.getIdentifiers().get(0));
        GetEtkResponse response = this.getETK(searchType);
        KeyDepotServiceImpl.validate(response);
        EncryptionToken etk = KeyDepotServiceImpl.toEncryptionToken(response.getETK());
        CertificateParser etkParser = new CertificateParser(etk.getAuthenticationCertificate());
        if (etkParser.getIdentifier().equals(identifier) && etkParser.getId().equalsIgnoreCase(id)) {
            result.add(etk);
        } else if (etkParser.getIdentifier().equals(IdentifierType.SSIN) && identifier.equals(IdentifierType.NIHII)) {
            LOG.debug("Request was based on NIHII number [{}] but SSIN recieved.", (Object)id);
            result.add(etk);
        } else {
            LOG.warn("Ignoring etk with SubjectX509Name [{}]", (Object)etk.getAuthenticationCertificate().getSubjectX500Principal().getName("RFC2253"));
        }
        return result;
    }

    private static void validate(GetEtkResponse response) throws TechnicalConnectorException {
        if (!response.getStatus().getCode().equalsIgnoreCase("200")) {
            LOG.error((Object)((Object)TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND) + ": " + ((LocalisedString)response.getStatus().getMessages().get(0)).getValue());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[0]);
        }
    }

    private static EncryptionToken toEncryptionToken(byte[] etk) throws TechnicalConnectorException {
        try {
            return new EncryptionToken(etk);
        }
        catch (GeneralSecurityException e) {
            LOG.error(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND.getMessage(), (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, (Throwable)e, new Object[0]);
        }
    }

    private static void unableToFindEtk(SearchCriteriaType searchType) throws TechnicalConnectorException {
        StringBuilder sb = new StringBuilder();
        if (LOG.isErrorEnabled()) {
            for (be.fgov.ehealth.etkdepot._1_0.protocol.IdentifierType identifier : searchType.getIdentifiers()) {
                sb.append("SearchCriteria:  type=[").append(identifier.getType()).append("] , value=[").append(identifier.getValue()).append("], appId=[").append(identifier.getApplicationID()).append("]");
            }
            LOG.error("No ETK found for {}", (Object)sb.toString());
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_ETK_NOTFOUND, new Object[0]);
    }

    @Override
    public void bootstrap() {
        JaxbContextFactory.initJaxbContext(GetEtkRequest.class);
        JaxbContextFactory.initJaxbContext(GetEtkResponse.class);
    }
}

