/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveProperties.class);
    private Properties uddi = new Properties();
    private Map<String, Lookup> lookups = RecursiveProperties.create(new RecursiveLookup(this), new UddiLookup(this.uddi, this), new SystemLookup());

    private static Map<String, Lookup> create(Lookup ... lookups) {
        RegexHashMap<String, Lookup> result = new RegexHashMap<String, Lookup>();
        for (Lookup lookup : lookups) {
            result.put(lookup.getRegex(), lookup);
        }
        return result;
    }

    RecursiveProperties(InputStream ... uddiStreams) {
        for (InputStream uddiStream : uddiStreams) {
            RecursiveProperties.load(uddiStream, this.uddi);
        }
    }

    RecursiveProperties(boolean load) throws TechnicalConnectorException {
        if (load) {
            this.defaultLoad();
        }
    }

    RecursiveProperties() throws TechnicalConnectorException {
        this(true);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return keyList.elements();
    }

    private void defaultLoad() throws TechnicalConnectorException {
        RecursiveProperties.load("/uddi/uddi-default.properties", this.uddi);
        RecursiveProperties.load(this.getProperty("uddi.local.cache.dir", ConnectorIOUtils.getTempFileLocation("uddi-local.properties")), this.uddi);
    }

    private static void load(String location, Properties properties) {
        try {
            RecursiveProperties.load(ConnectorIOUtils.getResourceAsStream(location, true), properties);
        }
        catch (Exception e) {
            LOG.warn("Unable to add properties from location [{}]", (Object)location);
        }
    }

    private static void load(InputStream is, Properties properties) {
        try {
            Properties props = new Properties();
            props.load(is);
            properties.putAll((Map<?, ?>)props);
        }
        catch (Exception e) {
            LOG.warn("Unable to add properties.", (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        LOG.debug("Resolving property for key [{}] with default value[{}]", (Object)key, (Object)defaultValue);
        String val = this.getProperty(key);
        if (val == null && defaultValue != null) {
            LOG.debug("Resolving defaultValue [{}]", (Object)defaultValue);
            val = this.getProperty(defaultValue);
            if (val == null) {
                val = defaultValue;
            }
        }
        return val;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, new ArrayList<String>());
    }

    private String getProperty(String key, List<String> lookupKeys) {
        if (key == null) {
            return null;
        }
        String value = super.getProperty(key);
        if (value == null) {
            value = key;
        }
        while (value != null && this.lookups.containsKey(value)) {
            value = this.lookups.get(value).process(value, lookupKeys);
        }
        if (value != null && value.equals(key)) {
            value = null;
        }
        LOG.debug("Returning value [{}] for property with key [{}].", (Object)value, (Object)key);
        return value;
    }

    private static class SystemLookup
    extends AbstractLookup {
        SystemLookup() {
            super("$system{", "}");
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            LOG.debug("Looking system-key [{}]", (Object)ref);
            return System.getProperty(ref);
        }
    }

    private static class UddiLookup
    extends AbstractLookup {
        private Properties uddi;
        private Properties config;

        public UddiLookup(Properties uddi, Properties config) {
            super("$uddi{", "}");
            this.uddi = uddi;
            this.config = config;
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            String env = this.config.getProperty("environment", "prd");
            String uddiKey = env + "-" + ref;
            LOG.debug("Looking uddi-key [{}]", (Object)uddiKey);
            return this.uddi.getProperty(uddiKey);
        }
    }

    private static class RecursiveLookup
    extends AbstractLookup {
        private RecursiveProperties props;

        public RecursiveLookup(RecursiveProperties props) {
            super("${", "}");
            this.props = props;
        }

        @Override
        String getRefValue(String ref, List<String> lookupKeys) {
            return this.props.getProperty(ref, lookupKeys);
        }
    }

    private static abstract class AbstractLookup
    implements Lookup {
        private final String regex;
        private Pattern pattern;
        private String startTag;
        private String endTag;

        private AbstractLookup(String startTag, String endTag) {
            this.regex = ".*" + Pattern.quote(startTag) + ".*" + Pattern.quote(endTag) + ".*";
            this.pattern = Pattern.compile(this.regex);
            this.startTag = startTag;
            this.endTag = endTag;
        }

        @Override
        public String getRegex() {
            return this.regex;
        }

        @Override
        public String process(String value, List<String> lookupKeys) {
            LOG.debug("Lookup value [{}]", (Object)value);
            if (value == null) {
                return null;
            }
            if (this.pattern.matcher(value).matches()) {
                HashSet<String> refs = new HashSet<String>(Arrays.asList(StringUtils.substringsBetween((String)value, (String)this.startTag, (String)this.endTag)));
                for (String ref : refs) {
                    if (lookupKeys.contains(ref)) {
                        throw new ConfigurationException("A circular reference detected.");
                    }
                    lookupKeys.add(ref);
                    String refValue = this.getRefValue(ref, lookupKeys);
                    String refTag = this.startTag + ref + this.endTag;
                    if (refValue != null) {
                        value = value.replace(refTag, refValue);
                        continue;
                    }
                    if (!value.equals(refTag)) {
                        value = value.replace(refTag, "");
                        continue;
                    }
                    value = null;
                }
            }
            LOG.debug("Returning value [{}]", (Object)value);
            return value;
        }

        abstract String getRefValue(String var1, List<String> var2);
    }

    private static interface Lookup {
        public String getRegex();

        public String process(String var1, List<String> var2);
    }

    private static class RegexHashMap<K, V>
    extends HashMap<K, V> {
        private Map<Pattern, V> matcherMap = new HashMap<Pattern, V>();

        private RegexHashMap() {
        }

        @Override
        public V get(Object key) {
            for (Map.Entry<Pattern, V> matcher : this.matcherMap.entrySet()) {
                if (!matcher.getKey().matcher(key.toString()).matches()) continue;
                return matcher.getValue();
            }
            return super.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            for (Map.Entry<Pattern, V> matcher : this.matcherMap.entrySet()) {
                if (!matcher.getKey().matcher(key.toString()).matches()) continue;
                return true;
            }
            return super.containsKey(key);
        }

        @Override
        public V put(K key, V value) {
            this.matcherMap.put(Pattern.compile(key.toString()), value);
            return super.put(key, value);
        }
    }
}

