/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleVersion
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleVersion.class);

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        if (LOG.isDebugEnabled()) {
            this.dumpJarFromCP();
            this.dumpServiceLoaderFiles();
        }
    }

    public void dumpJarFromCP() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            Object[] cpElements = ArrayUtils.EMPTY_STRING_ARRAY;
            while (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                StringBuilder sb = new StringBuilder("[CP Content] ");
                String substringAfterLast = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)url.getPath(), (String)"!"), (String)"/");
                if ("MANIFEST.MF".equals(substringAfterLast)) continue;
                sb.append(substringAfterLast);
                cpElements = (String[])ArrayUtils.add((Object[])cpElements, (Object)sb.toString());
            }
            Arrays.sort(cpElements);
            for (Object cpElement : cpElements) {
                LOG.debug((String)cpElement);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void dumpServiceLoaderFiles() {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/services");
            Object[] cpElements = ArrayUtils.EMPTY_STRING_ARRAY;
            while (resEnum.hasMoreElements()) {
                URL url = new URL(StringUtils.substringBeforeLast((String)resEnum.nextElement().getPath(), (String)"!"));
                StringBuilder sb = new StringBuilder("[JAR with ServiceLoader] ");
                sb.append(StringUtils.substringAfterLast((String)url.getPath(), (String)"/"));
                List<String> serviceServiceLoaderFiles = this.extractServiceLoaderFiles(url);
                sb.append(" (");
                for (int i = 0; i < serviceServiceLoaderFiles.size(); ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(serviceServiceLoaderFiles.get(i));
                }
                sb.append(")");
                cpElements = (String[])ArrayUtils.add((Object[])cpElements, (Object)sb.toString());
            }
            Arrays.sort(cpElements);
            for (Object cpElement : cpElements) {
                LOG.debug((String)cpElement);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> extractServiceLoaderFiles(URL url) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ZipInputStream zip = new ZipInputStream(url.openStream());
        ZipEntry ze = null;
        while ((ze = zip.getNextEntry()) != null) {
            String file;
            String entryName = ze.getName();
            if (!entryName.contains("META-INF/services") || !StringUtils.isNotBlank((CharSequence)(file = StringUtils.substringAfterLast((String)entryName, (String)"/")))) continue;
            result.add(file);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void unload() throws TechnicalConnectorException {
    }
}

