/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.client.impl;

import be.fedict.commons.eid.client.spi.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.lang.exception.ExceptionUtils;

public class CardTerminalsProxy
extends CardTerminals {
    private final CardTerminals delegate;
    private final Logger logger;

    public CardTerminalsProxy(CardTerminals delegate, Logger logger) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.logger = logger;
    }

    @Override
    public synchronized List<CardTerminal> list(CardTerminals.State state) throws CardException {
        return this.doList(state, true);
    }

    private synchronized List<CardTerminal> doList(CardTerminals.State state, boolean retryAfterServiceOnFailure) throws CardException {
        try {
            return this.delegate.list(state);
        }
        catch (CardException e) {
            if (retryAfterServiceOnFailure) {
                String rootCauseMessage;
                boolean reload = false;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (null != rootCause && null != (rootCauseMessage = rootCause.getMessage())) {
                    if (rootCauseMessage.contains("SCARD_E_SERVICE_STOPPED")) {
                        reload = true;
                    } else if (rootCauseMessage.contains("SCARD_E_NO_SERVICE")) {
                        reload = true;
                    }
                }
                if (reload) {
                    this.logger.debug("Smart card service is on failure. Trying to reload the JDK SmartCard service.");
                    this.reloadSmartCardService();
                    return this.doList(state, false);
                }
            }
            throw e;
        }
    }

    private synchronized void reloadSmartCardService() {
        try {
            Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
            Field contextId = pcscterminal.getDeclaredField("contextId");
            contextId.setAccessible(true);
            if (contextId.getLong(pcscterminal) == 0L) {
                return;
            }
            Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
            Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
            SCardEstablishContext.setAccessible(true);
            Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
            SCARD_SCOPE_USER.setAccessible(true);
            long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
            contextId.setLong(pcscterminal, newId);
            TerminalFactory factory = TerminalFactory.getDefault();
            CardTerminals terminals = factory.terminals();
            Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
            fieldTerminals.setAccessible(true);
            Class<?> classMap = Class.forName("java.util.Map");
            Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
            clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean waitForChange(long timeout) throws CardException {
        return this.delegate.waitForChange(timeout);
    }

    @Override
    public CardTerminal getTerminal(String name) {
        return this.delegate.getTerminal(name);
    }

    public static CardTerminals getCardTerminals(Logger logger) {
        TerminalFactory terminalFactory = TerminalFactory.getDefault();
        return new CardTerminalsProxy(terminalFactory.terminals(), logger);
    }
}

