/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SigningCredential {
    private final String subjectKeyIdentifier;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final List<X509Certificate> certificateChain;

    private SigningCredential(String subjectKeyIdentifier, PrivateKey privateKey, PublicKey publicKey, List<X509Certificate> certificateChain) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.certificateChain = certificateChain != null ? Collections.unmodifiableList(certificateChain) : Collections.emptyList();
    }

    public static SigningCredential create(List<X509Certificate> certificateChain) {
        return new SigningCredential(null, null, null, certificateChain);
    }

    public static SigningCredential create(X509Certificate ... certificateChain) {
        return SigningCredential.create(Iterables.newImmutableList(certificateChain));
    }

    public static SigningCredential create(PrivateKey privateKey, X509Certificate ... certificateChain) {
        return SigningCredential.create(privateKey, Iterables.newImmutableList(certificateChain));
    }

    public static SigningCredential create(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        return new SigningCredential(null, privateKey, null, certificateChain);
    }

    public static SigningCredential create(PrivateKey privateKey, String subjectKeyIdentifier) {
        return new SigningCredential(subjectKeyIdentifier, privateKey, null, null);
    }

    public static SigningCredential create(String subjectKeyIdentifier, PublicKey publicKey) {
        return new SigningCredential(subjectKeyIdentifier, null, publicKey, null);
    }

    public String getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SigningCredential)) {
            return false;
        }
        SigningCredential otherCredential = (SigningCredential)obj;
        return this.certificateChain.equals(otherCredential.certificateChain);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.certificateChain});
    }
}

