/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorArgs {
    private final Constructor<?> constructor;
    private final Object[] initArgs;

    public ConstructorArgs(Constructor<?> constructor, Object ... initArgs) {
        this.constructor = constructor;
        this.initArgs = initArgs;
        this.validateArgs();
    }

    private void validateArgs() {
        Class<?>[] paramTypes = this.constructor.getParameterTypes();
        if (this.initArgs.length != paramTypes.length) {
            throw new IllegalArgumentException("Number of provided arguments doesn't match constructor ones");
        }
        for (int i = 0; i < this.initArgs.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Object arg = this.initArgs[i];
            if (paramType.isPrimitive()) {
                if (arg == null) {
                    throw new IllegalArgumentException("Null argument for primitive param " + i);
                }
                try {
                    Field field = arg.getClass().getDeclaredField("TYPE");
                    Class argType = (Class)field.get(null);
                    if (paramType.equals(argType)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw this.throwException(paramType, arg);
                }
                throw this.throwException(paramType, arg);
            }
            if (arg == null || paramType.isAssignableFrom(arg.getClass())) continue;
            throw this.throwException(paramType, arg);
        }
    }

    private IllegalArgumentException throwException(Class<?> paramType, Object arg) {
        return new IllegalArgumentException(arg + " isn't of type " + paramType);
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

