/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.DataSealSteps;
import be.fgov.ehealth.etee.crypto.decrypt.DataUnsealer;
import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypter;
import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypterFactory;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierFactory;
import be.fgov.ehealth.etee.crypto.decrypt.TripleUnwrapper;
import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public final class DataUnsealerBuilder {
    private DataUnsealerBuilder() {
    }

    public static OCSPPolicyStep newBuilder() {
        SecurityConfiguration.configure();
        return new Steps();
    }

    private static class Steps
    extends DataSealSteps
    implements OCSPPolicyStep,
    SigningPolicyStep,
    PublicKeyPolicyStep,
    SecretKeyPolicyStep,
    BuildStep {
        private EncryptionPolicy publicKeyEncryptionPolicy;
        private EncryptionCredential[] encryptionCredentials;
        private EncryptionPolicy secretKeyEncryptionPolicy = EncryptionPolicy.UNKNOWN_RECIPIENT;

        private Steps() {
        }

        @Override
        public DataUnsealer build() {
            this.processConfig();
            EnvelopedDataDecrypter envelopedDataDecrypter = EnvelopedDataDecrypterFactory.getInstance().createEnvelopedDataDecrypter(this.publicKeyEncryptionPolicy, this.encryptionCredentials, this.secretKeyEncryptionPolicy);
            int[] acceptableKeyUsages = this.getSigningOptionsToUse().getBoolean(SigningOption.NON_REPUDIATION) != false ? NON_REPUDIATION_ACCEPTABLE_KEY_USAGES : DIGITAL_SIGNATURE_ACCEPTABLE_KEY_USAGES;
            SignedDataVerifierAbstract innerSignedDataVerifier = SignedDataVerifierFactory.getInstance().createInnerSignedDataVerifier(this.getSigningPolicies(), acceptableKeyUsages, this.getOcspChecker(), this.getCertPathChecker(), this.getSignerInfoAttributesReceiver());
            return new TripleUnwrapper(innerSignedDataVerifier, this.getOuterSignedDataVerifier(), envelopedDataDecrypter);
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy) {
            return this.addOCSPPolicy(policy, new HashMap<OCSPOption, Object>());
        }

        @Override
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy policy, Map<OCSPOption, Object> ocspOptions) {
            this.addConfig(policy, ocspOptions);
            return this;
        }

        @Override
        public PublicKeyPolicyStep addSigningPolicy(SigningPolicy ... signingPolicies) {
            return this.addSigningPolicy(null, new HashMap<SigningOption, Object>(), signingPolicies);
        }

        @Override
        public PublicKeyPolicyStep addSigningPolicy(KeyStore keyStore, SigningPolicy ... signingPolicies) {
            return this.addSigningPolicy(keyStore, new HashMap<SigningOption, Object>(), signingPolicies);
        }

        @Override
        public PublicKeyPolicyStep addSigningPolicy(KeyStore keyStore, Map<SigningOption, Object> signingOptions, SigningPolicy ... signingPolicies) {
            this.addConfig(keyStore, signingOptions, signingPolicies);
            return this;
        }

        @Override
        public SecretKeyPolicyStep addPublicKeyPolicy(EncryptionPolicy policy, EncryptionCredential ... credentials) {
            Preconditions.checkNotNull(policy, "PublicKeyEncryptionPolicy cannot be null.");
            Preconditions.checkNotEmpty(credentials, "EncryptionCredentials cannot be empty.");
            this.publicKeyEncryptionPolicy = policy;
            this.encryptionCredentials = credentials;
            return this;
        }

        @Override
        public BuildStep addSecretKeyPolicy(EncryptionPolicy encryptionPolicy) {
            Preconditions.checkNotNull(encryptionPolicy, "SecretKeyEncryptionPolicy cannot be null.");
            this.secretKeyEncryptionPolicy = encryptionPolicy;
            return this;
        }
    }

    public static interface BuildStep {
        public DataUnsealer build();
    }

    public static interface SecretKeyPolicyStep
    extends BuildStep {
        public BuildStep addSecretKeyPolicy(EncryptionPolicy var1);
    }

    public static interface PublicKeyPolicyStep {
        public SecretKeyPolicyStep addPublicKeyPolicy(EncryptionPolicy var1, EncryptionCredential ... var2);
    }

    public static interface SigningPolicyStep {
        public PublicKeyPolicyStep addSigningPolicy(SigningPolicy ... var1);

        public PublicKeyPolicyStep addSigningPolicy(KeyStore var1, SigningPolicy ... var2);

        public PublicKeyPolicyStep addSigningPolicy(KeyStore var1, Map<SigningOption, Object> var2, SigningPolicy ... var3);
    }

    public static interface OCSPPolicyStep
    extends SigningPolicyStep {
        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1);

        public SigningPolicyStep addOCSPPolicy(OCSPPolicy var1, Map<OCSPOption, Object> var2);
    }
}

