﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNet_eMOHDF102_V3_IntegrationTest
	{

	    private static String FILES_FOLDER = ".\\examples\\vsbnet\\async\\eHMOHDF102_ConsultHistory\\";
    
		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}

		// Prerequisites :
	    // 1 - Execute EMOHDF101(CreateApplication) 5_5a and 5_5b test
	    // 2 - Get the VSBReference returned in 5_5b and adapt the xml file
	    // 3 - Ask a validation of the vsb reference
	    
	    [Test]
	    public void test_5_1a_POST_ConsultHistory() {
	        VsbNetGenericAsyncMethod.do_POST_ConsultHistory(FILES_FOLDER + "vsb-mohm_DF102_5-1_TC_CONSHIST1_testlink_eWZC-3088_request.xml");
	    }
	
	    [Test]
	    public void test_5_1b_GET_ConsultHistory() {
	        VsbNetGenericAsyncMethod.do_GET_ConsultHistory(FILES_FOLDER + "vsb-mohm_DF102_5-1_TC_CONSHIST1_testlink_eWZC-3088_response.xml", false);
	    }
	
	    [Test]
	    public void test_5_2a_POST_ConsultHistory() {
	        VsbNetGenericAsyncMethod.do_POST_ConsultHistory(FILES_FOLDER + "vsb-mohm_DF102_5-2_TC_CONSHIST2_testlink_eWZC-3089_request.xml");
	    }
	
	    [Test]
	    public void test_5_2b_GET_ConsultHistory() {
	        VsbNetGenericAsyncMethod.do_GET_ConsultHistory(FILES_FOLDER + "vsb-mohm_DF102_5-2_TC_CONSHIST2_testlink_eWZC-3089_response.xml", false);
	    }
	}
}
