/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodSerializationWrapper
implements Serializable {
    private static final long serialVersionUID = 1775475200823842126L;
    private static final Map<String, Class<?>> primitiveTypes = new HashMap(10);
    private final String className;
    private final String methodName;
    private final String[] parameterTypeNames;

    public MethodSerializationWrapper(Method m) {
        this.className = m.getDeclaringClass().getName();
        this.methodName = m.getName();
        Class<?>[] parameterTypes = m.getParameterTypes();
        this.parameterTypeNames = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parameterTypeNames[i] = parameterTypes[i].getName();
        }
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
        Class[] parameterTypes = new Class[this.parameterTypeNames.length];
        for (int i = 0; i < this.parameterTypeNames.length; ++i) {
            Class<?> primitiveType = primitiveTypes.get(this.parameterTypeNames[i]);
            parameterTypes[i] = primitiveType != null ? primitiveType : Class.forName(this.parameterTypeNames[i], true, Thread.currentThread().getContextClassLoader());
        }
        Method m = clazz.getDeclaredMethod(this.methodName, parameterTypes);
        return m;
    }

    static {
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
        primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
        primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
    }
}

