﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.ws.domain;
using be.ehealth.technicalconnector.ws;
using Mock4Net.Core;
using NUnit.Framework;
using org.apache.commons.lang;
using System.IO;


namespace be.fgov.ehealth.technicalconnector.bootstrap.bcp
{
	[TestFixture]
	public class GenericRequestWithCachingTest
	{
		private FluentMockServer server6666 = FluentMockServer.Start(6666);


		[SetUp]
		public  void init()
		{
			java.lang.System.setProperty("be.fgov.ehealth.technicalconnector.bootstrap.tsl.autoupdater.active","false");
			ConfigFactory.getConfigValidator().setProperty("crypto.revocationstatuschecker.classname", "be.ehealth.technicalconnector.service.etee.impl.ConnectorMockRevocationStatusChecker");
			ConfigFactory.getConfigValidator().setProperty("connector.soaphandler.connection.request.timeout", "100");
			ConfigFactory.getConfigValidator().getConfig().setProperty("KEYSTORE_DIR", ".\\P12\\acc\\");
		}

		[Test]
		//With cache
		public void walk() {
			server6666.Given(Requests.WithUrl("/EtkDepot/v1").UsingPost())
				.RespondWith(
					Responses.WithStatusCode(200)
					.WithHeader("Content-Type","text/xml")
					.WithBody(ConnectorIOUtils.getResourceAsString(".\\samples\\etkdepot-response.xml")));
			
			server6666.Stop();
	
		    GenericRequest req = new GenericRequest();
			req.setPayload(ConnectorIOUtils.getResourceAsString(".\\samples\\etkdepot-request.xml"));
			req.setEndpoint("http://localhost:6666/EtkDepot/v1");
			String request = ServiceFactory.getGenericWsSender().send(req).asString();
			Assert.IsTrue(StringUtils.contains(request,"425ad6d2-d627-4749-add2-62599834b118"));
		}
	}
}
