﻿/*
 * Copyright (c) eHealth
 */
using System;

using be.ehealth.technicalconnector.enumeration;
using be.ehealth.technicalconnector.idgenerator;
using ikvm.extensions;
using javax.xml.ws.soap;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using java.io;
using java.util;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.businessconnector.vsbnet.async.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.businessconnector.genericasync.mappers;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.vlaanderen.mercurius.mohm.schemas.v1;
using be.vlaanderen.mercurius.insurability.schemas.v1;
using be.cin.encrypted;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	[TestFixture]
	public class VsbNetGetGenericAsyncIntegrationTest
	{

		private static string RESPONSE_FOLDER = ".\\examples\\vsbnet\\async\\response\\";
		
		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[Test]
		public void getCreateApplication_TC_APP1() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP1.xml", true);
		}

		[Test]
		public void getCreateApplication_TC_APP2() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP2.xml", true);
		}

		[Test]
		public void getCreateApplication_TC_APP3() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP3.xml", true);
		}

		[Test]
		public void getCreateApplication_TC_APP4() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP4.xml", true);
		}

		[Test]
		public void getCreateApplication_TC_APP5() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP5.xml", true);
		}

		[Test]
		public void getCreateApplication_TC_APP6() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(RESPONSE_FOLDER +"EMOHMDF101CreateApplicationResponse_TC_APP6.xml", true);
		}

		[Test]
		public void getConsultApplication_TC_CAPP1() {
			VsbNetGenericAsyncMethod.do_GET_ConsultApplication(RESPONSE_FOLDER +"EMOHMDF103ConsultApplicationResponse_TC_CAPP1.xml", true);

		}

		[Test]
		public void getConsultApplication_TC_CAPP2() {
			VsbNetGenericAsyncMethod.do_GET_ConsultApplication(RESPONSE_FOLDER +"EMOHMDF103ConsultApplicationResponse_TC_CAPP2.xml", true);
		}

		[Test]
		public void getReportDelivery_TC_DEL1() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(RESPONSE_FOLDER +"EMOHMDF105ReportDeliveryResponse_TC_DEL1.xml", true);
		}

		[Test]
		public void _140_getReportDelivery_TC_DEL2() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(RESPONSE_FOLDER +"EMOHMDF105ReportDeliveryResponse_TC_DEL2.xml", true);
		}

		[Test]
		public void getReportDelivery_TC_DEL3() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(RESPONSE_FOLDER +"EMOHMDF105ReportDeliveryResponse_TC_DEL3.xml", true);
		}

		[Test]
		public void getReportDelivery_TC_DEL4() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(RESPONSE_FOLDER +"EMOHMDF105ReportDeliveryResponse_TC_DEL4.xml", true);
		}

		[Test]
		public void getConsultSupportAndRepair_TC_CSUP1() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepair(RESPONSE_FOLDER +"EMOHMDF104ConsultSupportAndRepairResponse_TC_CSUP1.xml", true);
		}

		[Test]
		public void getConsultSupportAndRepair_TC_CSUP2() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepair(RESPONSE_FOLDER +"EMOHMDF104ConsultSupportAndRepairResponse_TC_CSUP2.xml", true);
		}

		[Test]
		[Ignore]
		public void getCreateFictionalApplicationResponse_TC_FAPP1() {
			VsbNetGenericAsyncMethod.do_GET_CreateFictionalApplication(RESPONSE_FOLDER +"EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP1.xml", true);
		}

		[Test]
		[Ignore]
		public void getCreateFictionalApplicationResponse_TC_FAPP2() {
			VsbNetGenericAsyncMethod.do_GET_CreateFictionalApplication(RESPONSE_FOLDER +"EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP2.xml", true);
		}

		[Test]
		[Ignore]
		public void getCreateFictionalApplicationResponse_TC_FAPP3() {
			VsbNetGenericAsyncMethod.do_GET_CreateFictionalApplication(RESPONSE_FOLDER +"EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP3.xml", true);
		}

		[Test]
		[Ignore]
		public void getCreateFictionalApplicationResponse_TC_FAPP4() {
			VsbNetGenericAsyncMethod.do_GET_CreateFictionalApplication(RESPONSE_FOLDER +"EMOHMDF102CreateFictionalApplicationResponse_TC_FAPP3.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES1() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES1.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES2() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES2.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES3() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES3.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES4() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES4.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES5() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES5.xml", true);
		}

		[Test]
		public void getPushDecision_TC_PDES6() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionRequest_TC_PDES6.xml", false);
		}

		[Test]
		public void getPushDecision_TC_PDES7() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(RESPONSE_FOLDER +"EMOHMDF106PushDecisionResponse_TC_PDES7.xml", true);
		}

		[Test]
		public void getPushApplicationView_TC_PVIEW() {
			VsbNetGenericAsyncMethod.do_GET_PushApplicationView(RESPONSE_FOLDER +"EMOHMDF107PushApplicationViewRequest_TC_PVIEW.xml", true);
		}

		[Test]
		public void getListInvoiceFileAccepted() {
			VsbNetGenericAsyncMethod.do_GET_ListInvoiceFileAccepted(RESPONSE_FOLDER +"921000_TC02.txt", true);
		}

		[Test]
		public void getListInvoiceAccepted1() {
			VsbNetGenericAsyncMethod.do_GET_ListInvoiceAccepted1(RESPONSE_FOLDER +"920098_TC02.txt", true);
		}

		[Test]
		public void getListInvoiceAccepted2() {
			VsbNetGenericAsyncMethod.do_GET_ListInvoiceAccepted2(RESPONSE_FOLDER +"920900_TC02.txt", true);
		}

		[Test]
		public void getListInvoiceRefused() {
			Assert.Fail("not testable at the time of release 3.16.0-beta-3");
		}

		[Test]
		public void getListInvoiceFileRefused() {
			VsbNetGenericAsyncMethod.do_GET_ListInvoiceFileRefused(RESPONSE_FOLDER +"920999_TC01.txt", true);
		}

		[Test]
		public void getDetermineInsurability_TC01() {
			VsbNetGenericAsyncMethod.do_GET_DetermineInsurability(RESPONSE_FOLDER +"WZCMHDF001DetermineInsurabilityResponse_TC_1.xml", true);
		}

		[Test]
		public void getDetermineInsurability_TC02() {
			VsbNetGenericAsyncMethod.do_GET_DetermineInsurability(RESPONSE_FOLDER +"WZCMHDF001DetermineInsurabilityResponse_TC_2.xml", true);
		}

		[Test]
		public void getDetermineInsurability_TC03() {
			VsbNetGenericAsyncMethod.do_GET_DetermineInsurability(RESPONSE_FOLDER +"WZCMHDF001DetermineInsurabilityResponse_TC_3.xml", true);
		}

		[Test]
		public void getDetermineInsurability_TC04() {
			VsbNetGenericAsyncMethod.do_GET_DetermineInsurability(RESPONSE_FOLDER +"WZCMHDF001DetermineInsurabilityResponse_TC_4.xml", true);
		}
	}
}
