/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

public enum EncryptionPolicy {
    KNOWN_RECIPIENT(2048, "1.2.840.113549.1.1.1", "2.16.840.1.101.3.4.1.2"),
    UNKNOWN_RECIPIENT(128, "2.16.840.1.101.3.4.1.5", "2.16.840.1.101.3.4.1.2");

    private final int keksize;
    private final String keyEncryptionAlgorithmOID;
    private final String contentEncryptionAlgorithmOID;

    private EncryptionPolicy(int keksize, String keyEncryptionAlgorithmOID, String contentEncryptionAlgorithmOID) {
        this.keksize = keksize;
        this.keyEncryptionAlgorithmOID = keyEncryptionAlgorithmOID;
        this.contentEncryptionAlgorithmOID = contentEncryptionAlgorithmOID;
    }

    public int getKeksize() {
        return this.keksize;
    }

    public String getContentEncryptionAlgorithmOID() {
        return this.contentEncryptionAlgorithmOID;
    }

    public String getKeyEncryptionAlgorithmOID() {
        return this.keyEncryptionAlgorithmOID;
    }

    private static class EncryptionOID {
        public static final String RSA = "1.2.840.113549.1.1.1";
        public static final String AES128_CBC_PAD = "2.16.840.1.101.3.4.1.2";
        public static final String AES128_WRAP = "2.16.840.1.101.3.4.1.5";

        private EncryptionOID() {
        }
    }
}

