﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNet_eMOHDF103_V4_IntegrationTest
	{

	    private static String FILES_FOLDER = ".\\examples\\vsbnet\\async\\eHMOHDF103_V4\\";
    
		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
	    // Prerequisites :
	    // 1 - Execute EMOHDF101(CreateApplication) 5_5a and 5_5b test
	    // 2 - Get the VSBReference returned in 5_5b and adapt the xml file
	    // 3 - Ask a validation of the vsb reference
	    
	    [Test]
	    public void test_5_1a_POST_ConsultApplicationV4() {
	        VsbNetGenericAsyncMethod.do_POST_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-1_TC_CAPP1_testlink_eWZC-3061_request.xml");
	    }
	
	    [Test]
	    public void test_5_1b_GET_ConsultApplicationV4() {
	        VsbNetGenericAsyncMethod.do_GET_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-1_TC_CAPP1_testlink_eWZC-3061_response.xml", false);
	    }
	
	    [Test]
	    public void test_5_2a_POST_ConsultApplicationV4() {
	        VsbNetGenericAsyncMethod.do_POST_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-2_TC_CAPP2_testlink_eWZC-3062_request.xml");
	    }
	
	    [Test]
	    public void test_5_2b_GET_ConsultApplicationV4() {
	        VsbNetGenericAsyncMethod.do_GET_ConsultApplicationV4(FILES_FOLDER + "vsb-mohm_DF103_5-2_TC_CAPP2_testlink_eWZC-3062_response.xml", false);
	    }

	}
}
