#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.utils
{
	using System;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.etee;
	using be.ehealth.technicalconnector.service.etee.impl;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.utils.impl;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
	
	using org.slf4j;

	using java.util;

	using NUnit.Framework;

	/**
	 * Example on how dynamicly load dotNET classes into IKVM java
	 */
	[TestFixture]
	public class ConfigurableFactoryHelperTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(ConfigurableFactoryHelper));

		private static Boolean invoked = false;
		#region Methods

		[Test]
		public void test()
		{
			ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper("be.ehealth.technicalconnector.utils.ConfigurableHelpTest.module",translateToJava(typeof(NetConfigModule)) ,typeof(ConfigurationModule));
			ConfigurationModule module =(ConfigurationModule) helper.getImplementation();
			module.init(null);
			Assert.IsTrue(invoked);
		}
		
		/**
		 * Helper method to translate a dotNET Type to an IKVM accessible java class.
		 */
		private string translateToJava(Type t)
		{
			return "cli."+t.FullName.Replace("+","$");
		}

		#endregion Methods
		#region Nested Types

		public class NetConfigModule : ConfigurationModule
		{
			#region Methods

			public void init(be.ehealth.technicalconnector.config.Configuration config)
			{
				LOG.info("NetConfigModule init");
				invoked = true;
			}
			
			public void unload()
			{
				LOG.info("NetConfigModule unload");
				invoked =false;
			}


			#endregion Methods
		}

		#endregion Nested Types
	}
}