/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.AbstractSignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.DomUtils;
import be.fgov.ehealth.technicalconnector.signature.impl.SignatureUtils;
import be.fgov.ehealth.technicalconnector.signature.impl.extractor.X509DataExctractor;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.XadesHandler;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.XadesSpecification;
import be.fgov.ehealth.technicalconnector.signature.resolvers.DocumentResolver;
import be.fgov.ehealth.technicalconnector.signature.transformers.EncapsulationTransformer;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureBuilder
extends AbstractSignatureBuilder
implements SignatureBuilder {
    public static final String XMLNS_DS = "http://www.w3.org/2000/09/xmldsig#";
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignatureBuilder.class);
    private XadesSpecification[] specs;
    private AdvancedElectronicSignatureEnumeration aes;

    public XmlSignatureBuilder(AdvancedElectronicSignatureEnumeration aes, XadesSpecification ... specs) {
        this.specs = specs;
        this.aes = aes;
    }

    private static void addKeyInfo(Credential signatureCredential, XMLSignature sig) throws TechnicalConnectorException, XMLSecurityException {
        if (signatureCredential.getCertificateChain() != null) {
            for (Certificate cert : signatureCredential.getCertificateChain()) {
                if (sig.getKeyInfo().itemX509Data(0) == null) {
                    X509Data x509data = new X509Data(sig.getDocument());
                    sig.getKeyInfo().add(x509data);
                }
                sig.getKeyInfo().itemX509Data(0).addCertificate((X509Certificate)cert);
            }
        }
    }

    private static boolean mustEncapsulate(List<String> transformerList) {
        return transformerList.contains("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
    }

    private static List<String> getTransformerList(Map<String, Object> optionMap) {
        boolean encapsulate = SignatureUtils.getOption("encapsulate", optionMap, Boolean.FALSE);
        List transformerList = SignatureUtils.getOption("transformerList", optionMap, new ArrayList());
        if (encapsulate && !transformerList.contains("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
            transformerList.add(0, "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        }
        return transformerList;
    }

    private static byte[] transform(boolean encapsulate, String xpathLocation, EncapsulationTransformer encapsulationTranformer, Document doc, XMLSignature sig) {
        Node insertBeforeNode;
        Node toInsert;
        block6: {
            if (!encapsulate) {
                return ConnectorXmlUtils.toByteArray((Node)sig.getElement());
            }
            toInsert = doc.adoptNode(encapsulationTranformer.transform(sig.getElement()));
            insertBeforeNode = null;
            if (StringUtils.isNotBlank((String)xpathLocation)) {
                try {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    NodeList nodes = (NodeList)xPath.evaluate(xpathLocation, doc.getDocumentElement(), XPathConstants.NODESET);
                    if (nodes.getLength() == 1) {
                        LOG.debug("1 node found, inserting at location [" + xpathLocation + "]");
                        insertBeforeNode = nodes.item(0);
                        break block6;
                    }
                    LOG.warn("XPATH error: " + nodes.getLength() + "found at location [" + xpathLocation + "],using default.");
                }
                catch (XPathExpressionException e) {
                    LOG.info("Unable to determine XPath Location, using default.", (Throwable)e);
                }
            } else {
                LOG.debug("Using default location (last child tag)");
            }
        }
        doc.getFirstChild().insertBefore(toInsert, insertBeforeNode);
        return ConnectorXmlUtils.toByteArray((Node)doc);
    }

    private static Transforms transforms(List<String> tranformerList, Document doc) throws TransformationException {
        Transforms baseDocTransform = new Transforms(doc);
        for (String transform : tranformerList) {
            baseDocTransform.addTransform(transform);
        }
        return baseDocTransform;
    }

    private static String ref(String id) {
        return "#" + id;
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteArrayToSign) throws TechnicalConnectorException {
        return this.sign(signatureCredential, byteArrayToSign, new HashMap<String, Object>());
    }

    @Override
    public byte[] sign(Credential signatureCredential, byte[] byteArrayToSign, Map<String, Object> options) throws TechnicalConnectorException {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (options != null) {
            optionMap.putAll(options);
        }
        this.validateInput(signatureCredential, byteArrayToSign);
        try {
            String xmldsigId = "xmldsig-" + IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
            String baseURI = SignatureUtils.getOption("baseURI", optionMap, "");
            String signatureMethodURI = SignatureUtils.getOption("signatureMethodURI", optionMap, this.determineDefaultAlgo(signatureCredential));
            String canonicalizationMethodURI = SignatureUtils.getOption("canonicalizationMethodURI", optionMap, "http://www.w3.org/2001/10/xml-exc-c14n#");
            String digestURI = SignatureUtils.getOption("digestURI", optionMap, "http://www.w3.org/2001/04/xmlenc#sha256");
            String encapsulateLocation = SignatureUtils.getOption("encapsulate-xpath", optionMap, null);
            EncapsulationTransformer encapsulationTranformer = SignatureUtils.getOption("encapsulate-transformer", optionMap, new PassthroughEncapsulationTransformer());
            List<String> transformerList = XmlSignatureBuilder.getTransformerList(optionMap);
            Document doc = ConnectorXmlUtils.toDocument((byte[])byteArrayToSign);
            XMLSignature sig = new XMLSignature(doc, baseURI, signatureMethodURI, canonicalizationMethodURI);
            sig.addResourceResolver((ResourceResolverSpi)new DocumentResolver(doc));
            sig.addDocument(XmlSignatureBuilder.ref(baseURI), XmlSignatureBuilder.transforms(transformerList, doc), digestURI);
            XmlSignatureBuilder.addKeyInfo(signatureCredential, sig);
            XadesHandler handler = new XadesHandler(sig, signatureCredential, options, this.specs);
            handler.before();
            sig.sign((Key)signatureCredential.getPrivateKey());
            sig.setId(xmldsigId);
            handler.after();
            return XmlSignatureBuilder.transform(XmlSignatureBuilder.mustEncapsulate(transformerList), encapsulateLocation, encapsulationTranformer, doc, sig);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    @Override
    public SignatureVerificationResult verify(byte[] signedByteArray, Map<String, Object> options) throws TechnicalConnectorException {
        Document signedContent = ConnectorXmlUtils.toDocument((byte[])signedByteArray);
        NodeList signatureList = DomUtils.getMatchingChilds(signedContent, XMLNS_DS, "Signature");
        if (signatureList == null || signatureList.getLength() == 0) {
            LOG.info("No signature found in signedContent");
            SignatureVerificationResult result = new SignatureVerificationResult();
            result.addError(SignatureVerificationError.SIGNATURE_NOT_PRESENT);
            return result;
        }
        if (signatureList.getLength() > 1) {
            LOG.info("Multiple signature found, using first one.");
        }
        return this.verify(signedContent, (Element)signatureList.item(0), options);
    }

    @Override
    public SignatureVerificationResult verify(byte[] signedByteArray, byte[] signature, Map<String, Object> options) throws TechnicalConnectorException {
        Element sigElement = ConnectorXmlUtils.toElement((byte[])signature);
        Document signedContent = ConnectorXmlUtils.toDocument((byte[])signedByteArray);
        return this.verify(signedContent, sigElement, options);
    }

    @Override
    public SignatureVerificationResult verify(Document signedContent, Element sigElement, Map<String, Object> options) throws TechnicalConnectorException {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        if (options != null) {
            optionMap.putAll(options);
        }
        SignatureVerificationResult result = new SignatureVerificationResult();
        NodeList signatureList = DomUtils.getMatchingChilds(signedContent, XMLNS_DS, "Signature");
        if (signatureList == null || signatureList.getLength() == 0) {
            LOG.info("Adding signature to signedContent");
            signedContent.getFirstChild().appendChild(signedContent.importNode(sigElement, true));
        }
        this.verifyXmlDsigSignature(result, sigElement, signedContent, optionMap);
        this.verifyManifest(result, sigElement, optionMap);
        for (XadesSpecification spec : this.specs) {
            spec.verify(result, sigElement);
        }
        this.validateChain(result, options);
        return result;
    }

    private void verifyManifest(SignatureVerificationResult result, Element sigElement, Map<String, Object> options) {
        Boolean followNestedManifest = SignatureUtils.getOption("followNestedManifest", options, Boolean.FALSE);
        if (followNestedManifest.booleanValue()) {
            Element signedInfo = (Element)DomUtils.getMatchingChilds(sigElement, XMLNS_DS, "SignedInfo").item(0);
            NodeList referencesList = DomUtils.getMatchingChilds(signedInfo, XMLNS_DS, "Reference");
            for (int i = 0; i < referencesList.getLength(); ++i) {
                Element reference = (Element)referencesList.item(i);
                String refType = reference.getAttribute("Type");
                if (!refType.endsWith("Manifest") || refType.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#Manifest")) continue;
                result.addError(SignatureVerificationError.SIGNATURE_MANIFEST_COULD_NOT_BE_VERIFIED);
            }
        }
    }

    private void verifyXmlDsigSignature(SignatureVerificationResult result, Element sigElement, Document signedContent, Map<String, Object> options) {
        try {
            String uri = IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
            XMLSignature xmlSignature = new XMLSignature(sigElement, uri);
            Boolean followNestedManifest = SignatureUtils.getOption("followNestedManifest", options, Boolean.FALSE);
            xmlSignature.setFollowNestedManifests(followNestedManifest.booleanValue());
            xmlSignature.addResourceResolver((ResourceResolverSpi)new DocumentResolver(signedContent));
            KeyInfo keyInfo = xmlSignature.getKeyInfo();
            keyInfo.setSecureValidation(false);
            X509DataExctractor extractor = new X509DataExctractor();
            result.getCertChain().addAll(extractor.extract(keyInfo));
            X509Certificate signingCert = this.extractEndCertificate(result.getCertChain());
            result.setSigningCert(signingCert);
            if (!xmlSignature.checkSignatureValue(signingCert)) {
                result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to verify XmlDsig Signature", (Throwable)e);
            result.addError(SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
        }
    }

    @Override
    public AdvancedElectronicSignatureEnumeration getSupportedAES() {
        return this.aes;
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    private static class PassthroughEncapsulationTransformer
    implements EncapsulationTransformer {
        private PassthroughEncapsulationTransformer() {
        }

        @Override
        public Node transform(Node signature) {
            return signature;
        }
    }
}

