/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.cert.CertPathCheckerBuilder;
import be.fgov.ehealth.etee.crypto.crl.CRLChecker;
import be.fgov.ehealth.etee.crypto.crl.CRLCheckerBuilder;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerImpl;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.SecurityConfiguration;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.Map;

public final class OCSPCheckerBuilder {
    private OCSPCheckerBuilder() {
    }

    public static OCSPPolicyStep newBuilder() {
        SecurityConfiguration.configure();
        return new Steps();
    }

    private static class Steps
    implements OCSPPolicyStep,
    BuildStep {
        private OCSPPolicy ocspPolicy;
        private Map<OCSPOption, Object> ocspOptions;

        private Steps() {
        }

        @Override
        public BuildStep addOCSPPolicy(OCSPPolicy ocspPolicy) {
            return this.addOCSPPolicy(ocspPolicy, new HashMap<OCSPOption, Object>());
        }

        @Override
        public BuildStep addOCSPPolicy(OCSPPolicy ocspPolicy, Map<OCSPOption, Object> options) {
            Preconditions.checkNotNull(ocspPolicy, "OCSPPolicy cannot be null.");
            Preconditions.checkNotNull(options, "OCSPOptions cannot be null.");
            this.ocspPolicy = ocspPolicy;
            this.ocspOptions = options;
            return this;
        }

        @Override
        public OCSPChecker build() {
            OCSPOptions options = OCSPOptions.defaultOptions().setAll(this.ocspOptions);
            KeyStore trustStore = options.getKeyStore(OCSPOption.TRUST_STORE);
            CertStore certStore = options.getCertStore(OCSPOption.CERT_STORE);
            CRLChecker crlChecker = CRLCheckerBuilder.newBuilder().addCertStore(certStore).build();
            CertPathChecker certPathChecker = CertPathCheckerBuilder.newBuilder().addTrustStore(trustStore).build();
            return new OCSPCheckerImpl(this.ocspPolicy, options, crlChecker, certPathChecker);
        }
    }

    public static interface BuildStep {
        public OCSPChecker build();
    }

    public static interface OCSPPolicyStep {
        public BuildStep addOCSPPolicy(OCSPPolicy var1);

        public BuildStep addOCSPPolicy(OCSPPolicy var1, Map<OCSPOption, Object> var2);
    }
}

