/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.cert.CertificateStatus;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;

public final class OCSPData {
    private CertificateStatus certStatus;
    private byte[] ocspResponse;
    private List<X509CRL> crls;

    public OCSPData(CertificateStatus certStatus, byte[] ocspResponse, List<X509CRL> crls) {
        Preconditions.checkNotNull(certStatus, "CertificateStatus cannot be null");
        this.certStatus = certStatus;
        this.ocspResponse = ocspResponse != null ? (byte[])ocspResponse.clone() : null;
        this.crls = crls != null ? crls : new ArrayList();
    }

    public CertificateStatus getCertStatus() {
        return this.certStatus;
    }

    public byte[] getOcspResponse() {
        return this.ocspResponse != null ? (byte[])this.ocspResponse.clone() : null;
    }

    public List<X509CRL> getCrls() {
        return this.crls;
    }

    boolean isRevoked() {
        return this.certStatus.equals((Object)CertificateStatus.REVOKED);
    }
}

