﻿
using System;
using be.ehealth.businessconnector.test.testcommons.utils;
using be.ehealth.businessconnector.vsbnetinsurability.session;
using be.fgov.ehealth.vsb.insurability.protocol.v1;
using ikvm.extensions;
using javax.xml.ws.soap;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.messageservices.core.v1;
using be.fgov.ehealth.mycarenet.commons.core.v2;
using be.fgov.ehealth.mycarenet.commons.protocol.v2;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.idgenerator;
using be.vlaanderen.mercurius.insurability.schemas.v1;

namespace be.ehealth.businessconnector.vsbnetinsurability.session
{


/**
 * Integration tests for VSBNet Insurability.
 * 
 * @author EHP
 * 
 */
[TestFixture]
public class VSBNetInsurabilityIntegrationTest {

    [SetUp]
    public static  void setupsession() {
        SessionInitializer.init(".\\be.ehealth.businessconnector.vsbnetinsurability.test.properties", SupportedLanguages.NET.getAbbreviation());
    }

    [TearDown]
    public static void teardownSession()  {
        Session.getInstance().unloadSession();
    }
    
    [Test]
    public void getInsurability_Success() {
        GetInsurabilityResponse response = createGetInsurabilityRequest(".\\examples\\request\\GetInsurability-success.xml");
        WZCMHDF001DetermineInsurabilityResponse businessResponse = (WZCMHDF001DetermineInsurabilityResponse) ConnectorXmlUtils.toObject(response.getReturn().getDetail().getValue(), typeof(WZCMHDF001DetermineInsurabilityResponse));
        Assert.AreEqual("35021198120", businessResponse.getPerson().getSsin());
        be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(ConnectorIOUtils.getResourceAsString(".\\examples\\response\\GetInsurability-success.xml"), ConnectorXmlUtils.toString(response));
    }

    [Test]
    public void getInsurability_IncorrectNihii() {
        try {
            createGetInsurabilityRequest(".\\examples\\request\\GetInsurability-IncorrectNihii.xml");
            Assert.Fail("This test should send an exception");
        } catch (SOAPFaultException e) {
            Assert.AreEqual("INCORRECT_NIHII_XXX_SAML: For trussmaker the NIHII '70127777123' in the CareProvider element must correspond to the 'urn:be:fgov:person:ssin:ehealth:1.0:nihii:trussmaker:nihii11' attribute in the SAML '62141168200'.", e.getMessage());
        }
    }

    [Test]
    public void getInsurability_IncorrectQuality() {
        try {
            createGetInsurabilityRequest(".\\examples\\request\\GetInsurability-IncorrectQuality.xml");
            Assert.Fail("This test should send an exception");
        } catch (SOAPFaultException e) {
            Assert.AreEqual("UNSUPPORTED_CAREPROVIDER: Not a supported care provider.", e.getMessage());
        }
    }
    
    private GetInsurabilityResponse createGetInsurabilityRequest(String testRequestFileLocation) {
        Map velocityContext = new HashMap();
        velocityContext.put("issueInstant", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'+02:00'").print(new org.joda.time.DateTime()));
        velocityContext.put("requestId", IdGeneratorFactory.getIdGenerator("uuid").generateId());
        velocityContext.put("currentDate", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
        
        GetInsurabilityRequest request = (GetInsurabilityRequest)FileTestUtils.toObject(velocityContext, testRequestFileLocation, typeof(GetInsurabilityRequest));
        return VSBNetInsurabilitySessionServiceFactory.getVSbNestInsurabilityService().getInsurability(request);
    }
}
   
}
