﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNet_eMOHDF112_IntegrationTest
	{

		private static String FILES_FOLDER = ".\\examples\\vsbnet\\async\\eHMOHDF112\\";

		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[Test]
		public void test_5_1_POST_CreateApplication() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvraag_rolstoel_request.xml");
		}

		[Test]
		public void test_5_1_GET_CreateApplication() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvraag_rolstoel_response.xml", false);
		}

		[Test]
		public void test_5_1_GET_PushDecision() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(FILES_FOLDER + "vsb-mohm_DF112_5_1_aanvaarde_beslissing_aanvraag_rolstoel.xml", false);
		}

		[Test]
		public void test_5_2_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_2_consultatie_supportandrepair_geen_actief_budget_gefaald_request.xml");
		}

		[Test]
		public void test_5_2_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_2_consultatie_supportandrepair_geen_actief_budget_gefaald_response.xml", true);
		}

		[Test]
		public void test_5_3_POST_ReportDelivery() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_3_aflevering_rolstoel_request.xml");
		}

		[Test]
		public void test_5_3_GET_ReportDelivery() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_3_aflevering_rolstoel_response.xml", false);
		}

		[Test]
		public void test_5_3_GET_PushDecision() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(FILES_FOLDER + "vsb-mohm_DF112_5_3_aanvaarde_beslissing_aflevering_rolstoel.xml", false);
		}

		[Test]
		public void test_5_4_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_4_consultatie_supportandrepair_ssin_één_budget_succes_request.xml");
		}

		[Test]
		public void test_5_4_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_4_consultatie_supportandrepair_ssin_één_budget_succes_response.xml", false);
		}

		[Test]
		public void test_5_5_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_5_consultatie_supportandrepair_prestatie_en_ssin_een_budget_succes_request.xml");
		}

		[Test]
		public void test_5_5_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_5_consultatie_supportandrepair_prestatie_en_ssin_een_budget_succes_request.xml", false);
		}

		[Test]
		public void test_5_6_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_6_consultatie_supportandrepair_vsbreferentie_een_budget_succes_request.xml");
		}

		[Test]
		public void test_5_6_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_6_consultatie_supportandrepair_vsbreferentie_een_budget_succes_response.xml", false);
		}

		[Test]
		public void test_5_7_POST_CreateApplication() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(FILES_FOLDER + "vsb-mohm_DF112_5_7_aanvraag_2de_rolstoel_request.xml");
		}

		[Test]
		public void test_5_7_GET_CreateApplication() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(FILES_FOLDER + "vsb-mohm_DF112_5_7_aanvraag_2de_rolstoel_response.xml", false);
		}

		[Test]
		public void test_5_7_GET_PushDecision_1() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(FILES_FOLDER + "vsb-mohm_DF112_5_7_aanvaarde_beslissing_aanvraag_2de_rolstoel.xml", false);
		}

		[Test]
		public void test_5_7_POST_ReportDelivery() {
			VsbNetGenericAsyncMethod.do_POST_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_7_aflevering_2de_rolstoel_request.xml");
		}

		[Test]
		public void test_5_7_GET_ReportDelivery() {
			VsbNetGenericAsyncMethod.do_GET_ReportDelivery(FILES_FOLDER + "vsb-mohm_DF112_5_7_aflevering_2de_rolstoel_response.xml", false);
		}

		[Test]
		public void test_5_7_GET_PushDecision_2() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(FILES_FOLDER + "vsb-mohm_DF112_5_7_aanvaarde_beslissing_aflevering_2de_rolstoel.xml", false);
		}

		[Test]
		public void test_5_8_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_8_consultatie_supportandrepair_ssin_meerdere_budgetten_succes_request.xml");
		}

		[Test]
		public void test_5_8_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_8_consultatie_supportandrepair_ssin_meerdere_budgetten_succes_response.xml", false);
		}

		[Test]
		public void test_5_9_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_9_consultatie_supportandrepair_ssin_niet_gekend_gefaald_request.xml");
		}

		[Test]
		public void test_5_9_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_9_consultatie_supportandrepair_ssin_niet_gekend_gefaald_response.xml", false);
		}

		[Test]
		public void test_5_10_POST_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_POST_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_10_consultatie_supportandrepair_geen_aanvraag_gefaald_request.xml");
		}

		[Test]
		public void test_5_10_GET_ConsultSupportAndRepairList() {
			VsbNetGenericAsyncMethod.do_GET_ConsultSupportAndRepairList(FILES_FOLDER + "vsb-mohm_DF112_5_10_consultatie_supportandrepair_geen_aanvraag_gefaald_response.xml", false);
		}
	}
}
