﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNet_eMOHDF111_IntegrationTest
	{

		private static string FILES_FOLDER = ".\\examples\\vsbnet\\async\\eHMOHDF111\\";
		
		[SetUp]
		public static void setup() {
			SessionInitializer.init("be.ehealth.businessconnector.vsbnet.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}
		
		[Test]
		public void test_4_1_POST_CreateApplication() {
			VsbNetGenericAsyncMethod.do_POST_CreateApplication(FILES_FOLDER + "vsb-mohm_DF111_4_1_aanvraag_loophulpmiddel_request.xml");
		}

		[Test]
		public void test_4_1_GET_CreateApplication() {
			VsbNetGenericAsyncMethod.do_GET_CreateApplication(FILES_FOLDER + "vsb-mohm_DF111_4_1_aanvraag_loophulpmiddel_response.xml", false);
		}

		[Test]
		public void test_4_1_GET_PushDecision() {
			VsbNetGenericAsyncMethod.do_GET_PushDecision(FILES_FOLDER + "vsb-mohm_DF111_4_1_aanvaarde_beslissing_aanvraag_loophulpmiddel.xml", false);
		}

		[Test]
		public void test_4_2_POST_CancelApplication() {
			VsbNetGenericAsyncMethod.do_POST_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_2_annulering_aanvraag_onderneming_niet_gemachtigd_gefaald_request.xml");
		}

		[Test]
		public void test_4_2_GET_CancelApplication() {
			VsbNetGenericAsyncMethod.do_GET_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_2_annulering_aanvraag_onderneming_niet_gemachtigd_gefaald_response.xml", false);
		}

		[Test]
		public void test_4_3_POST_CancelApplication() {
			VsbNetGenericAsyncMethod.do_POST_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_3_annulering_aanvraag_succes_request.xml");
		}

		[Test]
		public void test_4_3_GET_CancelApplication() {
			VsbNetGenericAsyncMethod.do_GET_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_3_annulering_aanvraag_succes_response.xml", false);
		}

		[Test]
		public void test_4_4_POST_CancelApplication() {
			VsbNetGenericAsyncMethod.do_POST_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_4_annulering_aanvraag_status_niet_correct_gefaald_request.xml");
		}

		[Test]
		public void test_4_4_GET_CancelApplication() {
			VsbNetGenericAsyncMethod.do_GET_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_4_annulering_aanvraag_status_niet_correct_gefaald_response.xml", false);
		}

		[Test]
		public void test_4_5_POST_CancelApplication() {
			VsbNetGenericAsyncMethod.do_POST_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_5_annulering_aanvraag_aanvraag_niet_gevonden_gefaald_response.xml");
		}

		[Test]
		public void test_4_5_GET_CancelApplication() {
			VsbNetGenericAsyncMethod.do_GET_CancelApplication(FILES_FOLDER + "vsb-mohm_DF111_4_5_annulering_aanvraag_aanvraag_niet_gevonden_gefaald_request.xml", false);
		}

	}
}
