/*
 * Copyright (c) eHealth
 */
using System;
using be.cin.nip.async.generic;
using be.cin.types.v1;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.test.helper;
using be.ehealth.businessconnector.genericasync.helper;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.utils;
using java.util;


/**
 * Example of usage for services not officially supported by the connector.
 * Here VL_INDREP VL_INDREP_CREATE_REQ and VL_INDREP_CREATE_RESP. In the example the projectName parameter is "vsb.indrep". 
 * 
 * @author EHP
 */
namespace be.ehealth.businessconnector.vsbnet.async.session
{
	public class VsbNetGenericUsage 
	{
   
    
        private Blob blobAgainstWhichXadesTManifestMustbeValidated;
        private String tackReferenceForWhichXadesTManifestMustbeValidated;

        public void postCreateIndicationReportExample() {
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.istest", "true");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.vsbnet.indrep.request.xadestype", "xades");
            ConfigFactory.getConfigValidator().setProperty("endpoint.genericasync.vsbnet.indrep.v1", "https://pilot.myvsbnet.be:9443/vsb/bed/GenAsync/VL_INDREP");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.encodingtype", "none");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.contenttype", "text/xml");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.blobbuilder.vsbnet.indrep.VL_INDREP_CREATE_REQ.contentencryption", "encryptedForKnownRecipient");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.username", "your licence username");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.password", "your licence password");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.name", "your package name");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiertype", "CBE");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiervalue", "The vsb identifier value");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.application", "The vsb application id");
  
            PostTestHelper testHelper = PostTestHelper.builder()
                .withProjectName("vsbnet.indrep")
                .withPlatformName("vsbnet")
                .hasXades(true).isTest(true)
                .isEncrypted(true)
                .build();
            byte[] request = ConnectorIOUtils.getResourceAsByteArray("your AVRDF501CreateIndicationReportRequest xml file");
        
            Post post = testHelper.buildPostRequest(request,
                    "VL_INDREP_CREATE_REQ");
            PostResponse postResponse = testHelper.post("vsbnet.indrep", post);
            testHelper.validateResponse(postResponse);
            
            blobAgainstWhichXadesTManifestMustbeValidated = post.getDetail();
            tackReferenceForWhichXadesTManifestMustbeValidated = postResponse.getReturn().getReference();
        }
    
        public void getCreateIndicationReportExample() {
            ConfigFactory.getConfigValidator().setProperty("endpoint.genericasync.vsbnet.indrep.v1", "https://pilot.myvsbnet.be:9443/vsb/bed/GenAsync/VL_INDREP");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.username", "your licence username");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.licence.password", "your licence password");
            ConfigFactory.getConfigValidator().setProperty("genericasync.vsbnet.indrep.package.name", "your package name");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiertype", "CBE");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.identifiervalue", "The vsb identifier value");
            ConfigFactory.getConfigValidator().setProperty("vsbnet.indrep.keydepot.application", "The vsb application id");
                        
            GetAndConfirmTestHelper testHelper = GetAndConfirmTestHelper.builder()
                    .withProjectName("vsbnet.indrep")
                    .withMessageNames(Arrays.asList("VL_INDREP_CREATE_RESP"))
                    .withMaxMessages(1)
                    .withOutputFileExtension(".txt")
                    .withOutputDir("indrep")
                    .isReplyToEtk(true)
                    .build();
            GetResponse getResponse = testHelper.performGetAndConfirm(false);
            TAckResponse tAckResponse = (TAckResponse) getResponse.getReturn().getTAckResponses().get(0);
            if (tAckResponse.getTAck().getReference().Equals(tackReferenceForWhichXadesTManifestMustbeValidated)) {
                new DefaultCommonAsyncService("vsbnet.indrep").validateXadesTWithManifest(tAckResponse,
                        blobAgainstWhichXadesTManifestMustbeValidated, tAckResponse.getXadesT().getValue());
            }    
        }
    }  
}
