/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.service.keydepot;

import java.util.Set;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.service.etee.domain.EncryptionToken;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;


/**
 * Testclass for the {@link KeyDepotManager}
 * 
 * @author EHP
 */
public class KeyDepotManagerIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(KeyDepotManagerIntegrationTest.class);

    private KeyDepotManager manager = KeyDepotManagerFactory.getKeyDepotManager();

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession()
                                                .build();

    @Test
    public void kgss() throws Exception {
        EncryptionToken etk = manager.getEtk(IdentifierType.CBE, 809394427L, "KGSS");
        Assert.assertNotNull(etk);
        AssertTools.assertEncryptionToken(etk);
    }

    @Test
    public void multipleEtk() throws Exception {
        Set<EncryptionToken> etk = manager.getEtkSet(IdentifierType.CBE, 809394427L, null);
        Assert.assertNotNull(etk);
        Assert.assertTrue(etk.size() > 1);
        for (EncryptionToken encryptionToken : etk) {
            LOG.debug(encryptionToken.getAuthenticationCertificate()
                                     .getSubjectDN()
                                     .toString());
            AssertTools.assertEncryptionToken(encryptionToken);
        }
    }

    @Test
    public void inss() throws Exception {
        EncryptionToken etk = manager.getEtk(IdentifierType.SSIN, 82051234978L, "");
        Assert.assertNotNull(etk);
        AssertTools.assertEncryptionToken(etk);
    }

    @Test
    public void nihii() throws Exception {
        EncryptionToken etk = manager.getEtk(IdentifierType.NIHII, 18334780L, null);
        Assert.assertNotNull(etk);
        AssertTools.assertEncryptionToken(etk);
    }

}
