﻿using be.ehealth.technicalconnector.handler;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.session;
using java.util;
using javax.xml.soap;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.ws
{
	using System;
	using System.IO;
	using System.Text;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.config.impl;
	using be.ehealth.technicalconnector.exception;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.service.sts.security.impl;
	using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
	using be.ehealth.technicalconnector.ws;
	using be.ehealth.technicalconnector.ws.domain;
	using be.ehealth.technicalconnector.ws.impl;

	using javax.xml.parsers;

	using NUnit.Framework;

	using org.w3c.dom;
	using org.xml.sax;

	/**
	 * The Class GenericWsCertSecured.
	 */
	[TestFixture]
	class GenericWSCertSecuredIntegrationTest
	{
		#region Fields

		private static Properties props;
		
		#endregion Fields
		
		#region Methods

		[SetUp]
		public static void init()
		{
			SessionInitializer.init(false);
			props = TestPropertiesNetLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",".net");
		}
		
        [TearDown]
        public void destroy(){
        	Session.getInstance().unloadSession();
        }
        
		/**
		 * Use the Generic Certificate Secured Web Service method on the Platform Integration Test
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Get the Certificate to use
		 * <li>3. Get the payload
		 * <li>4. Send the message
		 */
		[Test]
		public void testSendCertSecuredString() {
			Assert.IsNotNull(invoke().asString());
		}

		/**
		 * Use the Generic Certificate Secured Web Service method on the Platform Integration Test
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Get the Certificate to use
		 * <li>3. Get the payload
		 * <li>4. Send the message
		 */
		[Test]
		public void testSendCertSecuredDOM() {
			Assert.IsNotNull(invoke().asNode());
		}

		private GenericResponse invoke() {
			GenericRequest request = new GenericRequest();

			// 1. Set the URL to the web service end-point
			request.setEndpoint(props.getProperty("test.secured.endpoint"));

			// 2. Get the Certificate to use
			Credential credential = new KeyStoreCredential(props.getProperty("test.keystore.location"), props.getProperty("test.keystore.alias"), props.getProperty("test.keystore.password"));
			request.setCredential(credential, TokenType.X509);
			request.addDefaulHandlerChain();

			// 3. Get the payload
			request.setPayload(getPayload());

			// 4. Send the message
			return be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(request);
		}

		/**
		 * Builds the payload (string) for the request.
		 */
		private String getPayload() {
			StringBuilder sb = new StringBuilder();
			sb.Append("<CheckAccessControlRequest xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:v1\">");
			sb.Append("<Message xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">Hello this is your captain speeking</Message>");
			sb.Append("<Timestamp xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">");
			sb.Append(DateUtils.printDateTime(new org.joda.time.DateTime()));
			sb.Append("</Timestamp>");
			sb.Append("</CheckAccessControlRequest>");
			return sb.ToString();

		}

		#endregion Methods
	}
}